/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SoundHelper {
    private static final float volumeLimit = 2.0f;
    private static final float standardPitch = 1.0f;
    public static final Random RNG = new Random();

    public static void playLightningStrikeSounds(Entity soundEmissionTarget) {
        Player player = SoundHelper.getPlayerFrom(soundEmissionTarget);
        soundEmissionTarget.f_19853_.m_5594_(player, soundEmissionTarget.m_20183_(), SoundEvents.f_12090_, soundEmissionTarget.m_5720_(), 2.0f, 0.8f + RNG.nextFloat() * 0.2f);
        soundEmissionTarget.f_19853_.m_6263_(player, soundEmissionTarget.m_20185_(), soundEmissionTarget.m_20186_(), soundEmissionTarget.m_20189_(), SoundEvents.f_12089_, soundEmissionTarget.m_5720_(), 2.0f, 0.5f + RNG.nextFloat() * 0.2f);
    }

    public static void playGenericExplodeSound(Entity soundEmissionTarget) {
        soundEmissionTarget.f_19853_.m_7785_(soundEmissionTarget.m_20185_(), soundEmissionTarget.m_20186_(), soundEmissionTarget.m_20189_(), SoundEvents.f_11913_, soundEmissionTarget.m_5720_(), 2.0f, (1.0f + (RNG.nextFloat() - RNG.nextFloat()) * 0.2f) * 0.7f, false);
    }

    public static void playBoltImpactSound(Entity soundEmissionTarget) {
        soundEmissionTarget.f_19853_.m_5594_(SoundHelper.getPlayerFrom(soundEmissionTarget), soundEmissionTarget.m_20183_(), SoundEvents.f_12089_, soundEmissionTarget.m_5720_(), 2.0f, 0.5f + RNG.nextFloat() * 0.2f);
    }

    public static void playAttackSweepSound(Entity soundEmissionTarget) {
        soundEmissionTarget.f_19853_.m_5594_(SoundHelper.getPlayerFrom(soundEmissionTarget), soundEmissionTarget.m_20183_(), SoundEvents.f_12317_, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
    }

    public static void playBellSound(Entity soundEmissionTarget) {
        Player player = SoundHelper.getPlayerFrom(soundEmissionTarget);
        soundEmissionTarget.f_19853_.m_5594_(player, soundEmissionTarget.m_20183_(), SoundEvents.f_11699_, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
        soundEmissionTarget.f_19853_.m_5594_(player, soundEmissionTarget.m_20183_(), SoundEvents.f_11700_, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
    }

    public static void playCreatureSound(Entity soundEmissionTarget, SoundEvent soundEvent) {
        soundEmissionTarget.f_19853_.m_5594_(SoundHelper.getPlayerFrom(soundEmissionTarget), soundEmissionTarget.m_20183_(), soundEvent, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
    }

    public static void playBeaconSound(Entity soundEmissionTarget, boolean activate) {
        if (activate) {
            soundEmissionTarget.f_19853_.m_5594_(SoundHelper.getPlayerFrom(soundEmissionTarget), soundEmissionTarget.m_20183_(), SoundEvents.f_11736_, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
        } else {
            soundEmissionTarget.f_19853_.m_5594_(SoundHelper.getPlayerFrom(soundEmissionTarget), soundEmissionTarget.m_20183_(), SoundEvents.f_11738_, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
        }
    }

    public static void playHornSound(Entity soundEmissionTarget) {
        soundEmissionTarget.f_19853_.m_5594_(SoundHelper.getPlayerFrom(soundEmissionTarget), soundEmissionTarget.m_20183_(), SoundEvents.f_12355_, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
    }

    public static void playKnockbackSound(Entity soundEmissionTarget) {
        soundEmissionTarget.f_19853_.m_5594_(SoundHelper.getPlayerFrom(soundEmissionTarget), soundEmissionTarget.m_20183_(), SoundEvents.f_12314_, soundEmissionTarget.m_5720_(), 2.0f, 1.0f);
    }

    @Nullable
    private static Player getPlayerFrom(Entity soundEmissionTarget) {
        return soundEmissionTarget instanceof Player ? (Player)soundEmissionTarget : null;
    }
}

