/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import plus.dragons.visuality.Visuality;
import plus.dragons.visuality.config.ReloadableJsonConfig;
import plus.dragons.visuality.data.ParticleWithVelocity;
import plus.dragons.visuality.data.VisualityCodecs;
import plus.dragons.visuality.registry.VisualityParticles;

public class EntityHitParticleConfig
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int minAmount = 1;
    private int maxAmount = 20;
    private List<Entry> entries;
    private final IdentityHashMap<EntityType<?>, ParticleWithVelocity> particles = new IdentityHashMap();

    public EntityHitParticleConfig() {
        super(Visuality.location("particle_emitters/entity_hit"));
        this.entries = EntityHitParticleConfig.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (EntityType<?> type : entry.entities) {
                this.particles.put(type, entry.particle);
            }
        }
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this::spawnParticles);
    }

    public void spawnParticles(LivingAttackEvent event) {
        if (!this.enabled) {
            return;
        }
        DamageSource damageSource = event.getSource();
        LivingEntity entity = event.getEntity();
        if (!entity.f_19853_.f_46443_) {
            return;
        }
        EntityType type = entity.m_6095_();
        if (!this.particles.containsKey(type)) {
            return;
        }
        double amount = 0.0;
        Entity sourceEntity = damageSource.m_7640_();
        if (sourceEntity == null) {
            return;
        }
        if (sourceEntity instanceof LivingEntity) {
            amount = this.getAttackDamage((LivingEntity)sourceEntity);
        } else if (sourceEntity instanceof ThrownTrident) {
            amount = 8.0;
        } else if (sourceEntity instanceof AbstractArrow) {
            amount = ((AbstractArrow)sourceEntity).m_36789_() * 2.0;
        }
        if (amount <= 0.0) {
            return;
        }
        int count = Mth.m_14045_((int)Mth.m_14165_((double)amount), (int)this.minAmount, (int)this.maxAmount);
        ParticleWithVelocity particle = this.particles.get(entity.m_6095_());
        double x = entity.m_20185_();
        double y = entity.m_20227_(0.5);
        double z = entity.m_20189_();
        for (int i = 0; i < count; ++i) {
            particle.spawn(entity.f_19853_, x, y, z);
        }
    }

    private double getAttackDamage(LivingEntity attacker) {
        Collection modifiers = attacker.m_21205_().m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
        double base = 0.0;
        if (attacker.m_21204_().m_22171_(Attributes.f_22281_)) {
            base = attacker.m_21172_(Attributes.f_22281_);
        }
        double addition = 0.0;
        double multiplyBase = 1.0;
        double multiplyTotal = 1.0;
        for (AttributeModifier modifier : modifiers) {
            switch (modifier.m_22217_()) {
                case ADDITION: {
                    addition += modifier.m_22218_();
                    break;
                }
                case MULTIPLY_BASE: {
                    multiplyBase += modifier.m_22218_();
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multiplyTotal *= 1.0 + modifier.m_22218_();
                }
            }
        }
        return (base + addition) * multiplyBase * multiplyTotal;
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.m_6180_(source);
        if (config) {
            this.enabled = GsonHelper.m_13855_((JsonObject)input, (String)"enabled", (boolean)true);
            this.minAmount = GsonHelper.m_13824_((JsonObject)input, (String)"min_amount", (int)1);
            this.maxAmount = GsonHelper.m_13824_((JsonObject)input, (String)"max_amount", (int)20);
        }
        if ((array = GsonHelper.m_13832_((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.m_7238_();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.PartialResult)data.error().get()).message()});
                continue;
            }
            if (data.result().isPresent()) {
                newEntries.add((Entry)data.result().get());
                continue;
            }
            save = config;
            this.logger.warn("Error parsing {} from {}: Missing decode result", (Object)this.id, (Object)source);
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry : newEntries) {
            for (EntityType<?> type : entry.entities) {
                this.particles.put(type, entry.particle);
            }
        }
        profiler.m_7238_();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("min_amount", (Number)this.minAmount);
        object.addProperty("max_amount", (Number)this.maxAmount);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow(true, msg -> this.logger.error("Failed to serialize config entries: {}", msg)));
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(Entry.of((ParticleOptions)VisualityParticles.BONE.get(), EntityType.f_20524_, EntityType.f_20525_, EntityType.f_20481_));
        entries.add(Entry.of((ParticleOptions)VisualityParticles.WITHER_BONE.get(), EntityType.f_20497_));
        entries.add(Entry.of((ParticleOptions)VisualityParticles.FEATHER.get(), EntityType.f_20555_));
        entries.add(Entry.of((ParticleOptions)VisualityParticles.EMERALD.get(), EntityType.f_20492_, EntityType.f_20494_));
        return entries;
    }

    private record Entry(List<EntityType<?>> entities, ParticleWithVelocity particle) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compressedListOf(ForgeRegistries.ENTITY_TYPES.getCodec()).fieldOf("entity").forGetter(Entry::entities), (App)ParticleWithVelocity.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        private static Entry of(ParticleOptions particle, EntityType<?> ... types) {
            return new Entry(List.of(types), ParticleWithVelocity.ofZeroVelocity(particle));
        }
    }
}

