/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle.type;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ColorScaleParticleType
extends ParticleType<Options> {
    private final Codec<Options> codec = RecordCodecBuilder.create(instance -> instance.group((App)Vector3f.f_176762_.fieldOf("color").forGetter(Options::color), (App)Codec.FLOAT.fieldOf("scale").forGetter(Options::scale)).apply((Applicative)instance, (x$0, x$1) -> new Options((Vector3f)x$0, (float)x$1)));

    public ColorScaleParticleType(boolean overrideLimiter) {
        super(overrideLimiter, (ParticleOptions.Deserializer)Deserializer.INSTANCE);
    }

    public ColorScaleParticleType() {
        this(false);
    }

    public Options withColor(float r, float g, float b) {
        return new Options(r, g, b, 1.0f);
    }

    public Options withColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Options(r, g, b, 1.0f);
    }

    public Options withColorAndScale(float r, float g, float b, float scale) {
        return new Options(r, g, b, scale);
    }

    public Options withColorAndScale(int color, float scale) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Options(r, g, b, scale);
    }

    public Codec<Options> m_7652_() {
        return this.codec;
    }

    private static enum Deserializer implements ParticleOptions.Deserializer<Options>
    {
        INSTANCE;


        public Options fromCommand(ParticleType<Options> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            ColorScaleParticleType colorScaleParticleType = (ColorScaleParticleType)type;
            Objects.requireNonNull(colorScaleParticleType);
            return colorScaleParticleType.new Options(r, g, b, scale);
        }

        public Options fromNetwork(ParticleType<Options> type, FriendlyByteBuf buffer) {
            ColorScaleParticleType colorScaleParticleType = (ColorScaleParticleType)type;
            Objects.requireNonNull(colorScaleParticleType);
            return colorScaleParticleType.new Options(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }

    public class Options
    implements ParticleOptions {
        public final float r;
        public final float g;
        public final float b;
        public final float scale;

        private Options(float r, float g, float b, float scale) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
        }

        private Options(Vector3f vec, float scale) {
            this(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), scale);
        }

        public Vector3f color() {
            return new Vector3f(this.r, this.g, this.b);
        }

        public float scale() {
            return this.scale;
        }

        public ParticleType<?> m_6012_() {
            return ColorScaleParticleType.this;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale));
        }
    }
}

