/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dqu.additionaladditions.AdditionalRegistry;
import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AdditionalLootModifier
extends LootModifier {
    private static final ResourceLocation ELDER_GUARDIAN_LOOT_TABLE_ID = EntityType.f_20563_.m_20677_();
    private static final ResourceLocation ZOMBIE_LOOT_TABLE_ID = EntityType.f_20501_.m_20677_();
    private static final ResourceLocation CREEPER_LOOT_TABLE_ID = EntityType.f_20558_.m_20677_();
    private static final ResourceLocation PIGLIN_BARTERING_LOOT_TABLE_ID = BuiltInLootTables.f_78738_;
    private static final ResourceLocation MINESHAFT_CHEST_LOOT_TABLE_ID = BuiltInLootTables.f_78759_;
    private static final ResourceLocation DUNGEON_CHEST_LOOT_TABLE_ID = BuiltInLootTables.f_78742_;
    private static final ResourceLocation STRONGHOLD_CHEST_LOOT_TABLE_ID = BuiltInLootTables.f_78763_;
    private static final ResourceLocation MANSION_CHEST_LOOT_TABLE_ID = BuiltInLootTables.f_78689_;
    private static final ResourceLocation SHIPWRECK_SUPPLY_CHEST_LOOT_TABLE_ID = BuiltInLootTables.f_78694_;
    protected final LootItemCondition[] conditions;
    public static final Supplier<Codec<AdditionalLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AdditionalLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AdditionalLootModifier::new)));

    public AdditionalLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.conditions = conditionsIn;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LootPool pool;
        ResourceLocation id = context.getQueriedLootTableId();
        if (ELDER_GUARDIAN_LOOT_TABLE_ID.equals((Object)id) && Config.getBool(ConfigValues.TRIDENT_SHARD)) {
            pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.TRIDENT_SHARD.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.33f)).m_79082_();
            pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
        }
        if (DUNGEON_CHEST_LOOT_TABLE_ID.equals((Object)id) || MINESHAFT_CHEST_LOOT_TABLE_ID.equals((Object)id) || STRONGHOLD_CHEST_LOOT_TABLE_ID.equals((Object)id)) {
            if (Config.getBool(ConfigValues.GLOW_STICK)) {
                pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)4.0f)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.GLOW_STICK_ITEM.get()))).m_79082_();
                pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
            }
            if (Config.getBool(ConfigValues.ROPES)) {
                pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.ROPE_ITEM.get()))).m_79082_();
                pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
            }
            if (Config.getBool(ConfigValues.DEPTH_METER, "enabled")) {
                pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.1f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.DEPTH_METER_ITEM.get()))).m_79082_();
                pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
            }
        }
        if ((DUNGEON_CHEST_LOOT_TABLE_ID.equals((Object)id) || MANSION_CHEST_LOOT_TABLE_ID.equals((Object)id)) && Config.getBool(ConfigValues.MUSIC_DISCS)) {
            pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.25f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.MUSIC_DISC_0308.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.MUSIC_DISC_1007.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.MUSIC_DISC_1507.get()))).m_79082_();
            pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
        }
        if (SHIPWRECK_SUPPLY_CHEST_LOOT_TABLE_ID.equals((Object)id) && Config.getBool(ConfigValues.SHIPWRECK_SPYGLASS_LOOT)) {
            pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.5f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151059_)).m_79082_();
            pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
        }
        if ((ZOMBIE_LOOT_TABLE_ID.equals((Object)id) || CREEPER_LOOT_TABLE_ID.equals((Object)id)) && Config.getBool(ConfigValues.CHICKEN_NUGGET)) {
            pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.1f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.CHICKEN_NUGGET.get()))).m_79082_();
            pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
        }
        if (PIGLIN_BARTERING_LOOT_TABLE_ID.equals((Object)id) && Config.getBool(ConfigValues.GOLD_RING)) {
            pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.015f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)AdditionalRegistry.GOLD_RING.get()))).m_79082_();
            pool.m_79053_(arg_0 -> generatedLoot.add(arg_0), context);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

