/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.behaviour;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dqu.additionaladditions.AdditionalAdditions;
import dqu.additionaladditions.behaviour.BehaviourValues;
import dqu.additionaladditions.config.ConfigProperty;
import dqu.additionaladditions.config.value.BooleanConfigValue;
import dqu.additionaladditions.config.value.FloatConfigValue;
import dqu.additionaladditions.config.value.IntegerConfigValue;
import dqu.additionaladditions.config.value.ListConfigValue;
import dqu.additionaladditions.config.value.StringConfigValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BehaviourManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private Map<ResourceLocation, ConfigProperty> behaviours = ImmutableMap.of();
    public static BehaviourManager INSTANCE = new BehaviourManager();
    public static int loads;

    public BehaviourManager() {
        super(GSON, "behaviour");
    }

    public String m_7812_() {
        return "behaviour";
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, ConfigProperty> hashMap = new HashMap<ResourceLocation, ConfigProperty>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            if (!resourceLocation.m_135827_().equals("additionaladditions")) continue;
            JsonElement jsonElement = entry.getValue();
            List<ConfigProperty> properties = BehaviourManager.loadBehaviour(resourceLocation, jsonElement);
            ListConfigValue listConfigValue = new ListConfigValue().putAll(properties);
            hashMap.put(resourceLocation, new ConfigProperty(resourceLocation.m_135815_(), listConfigValue));
        }
        this.behaviours = ImmutableMap.copyOf(hashMap);
        AdditionalAdditions.LOGGER.info("[{}] Loaded {} behaviours", (Object)"additionaladditions", (Object)this.behaviours.size());
        ++loads;
    }

    private static List<ConfigProperty> loadBehaviour(ResourceLocation resourceLocation, JsonElement jsonElement) {
        JsonObject object = jsonElement.getAsJsonObject();
        ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
        for (Map.Entry entry : object.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            BehaviourValues.getByName(key).ifPresentOrElse(behaviour -> {
                switch (behaviour.getType()) {
                    case STRING: {
                        properties.add(new ConfigProperty(key, new StringConfigValue(value.getAsString())));
                        break;
                    }
                    case BOOLEAN: {
                        properties.add(new ConfigProperty(key, new BooleanConfigValue(value.getAsBoolean())));
                        break;
                    }
                    case INTEGER: {
                        properties.add(new ConfigProperty(key, new IntegerConfigValue(value.getAsInt())));
                        break;
                    }
                    case FLOAT: {
                        properties.add(new ConfigProperty(key, new FloatConfigValue(Float.valueOf(value.getAsFloat()))));
                        break;
                    }
                    default: {
                        AdditionalAdditions.LOGGER.warn("[{}] Incorrect property: {} in behaviour {}. This shouldn't happen, please report.", new Object[]{"additionaladditions", key, resourceLocation.m_135815_()});
                    }
                }
            }, () -> AdditionalAdditions.LOGGER.warn("[{}] Unknown property: {} in behaviour {}.", new Object[]{"additionaladditions", key, resourceLocation.m_135815_()}));
        }
        return properties;
    }

    public ConfigProperty getBehaviour(String name) {
        return this.behaviours.get(new ResourceLocation("additionaladditions", name));
    }

    public <T> T getBehaviourValue(String name, BehaviourValues values) {
        String key;
        ConfigProperty property = this.getBehaviour(name);
        if (property == null) {
            return null;
        }
        ListConfigValue list = (ListConfigValue)property.value();
        if (list.get(key = values.getName()) == null || list.get(key).value() == null) {
            return null;
        }
        return (T)list.get(key).value().getValue();
    }

    public Map<ResourceLocation, ConfigProperty> getBehaviours() {
        return this.behaviours;
    }
}

