/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.item;

import dqu.additionaladditions.config.Config;
import dqu.additionaladditions.config.ConfigValues;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.NotNull;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties settings) {
        super(settings);
    }

    private boolean tryPlacing(BlockPos pos, BlockState state, Level world, ItemStack stack, Optional<Player> player, Optional<InteractionHand> hand) {
        if (state.m_60710_((LevelReader)world, pos) && state.m_60734_().m_155943_() >= 0.0f) {
            world.m_46597_(pos, state);
            if (world.m_5776_()) {
                return true;
            }
            player.ifPresentOrElse(pl -> {
                if (!pl.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)pl, PlayerEntity -> pl.m_21190_((InteractionHand)hand.get()));
                }
            }, () -> {
                if (stack.m_220157_(1, world.f_46441_, null)) {
                    stack.m_41774_(1);
                }
            });
            world.m_5594_(null, pos, SoundEvents.f_144231_, SoundSource.AMBIENT, 2.0f, 1.0f);
            return true;
        }
        return false;
    }

    private InteractionResult rotate(BlockPos pos, BlockState state, Level world, ItemStack stack, Optional<Player> player, Optional<InteractionHand> hand) {
        BlockState newstate;
        if (!Config.getBool(ConfigValues.WRENCH)) {
            return InteractionResult.FAIL;
        }
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        if (state.m_60734_() instanceof ChestBlock || state.m_60734_() instanceof BedBlock) {
            return InteractionResult.PASS;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_) && this.tryPlacing(pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61372_), world, stack, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61373_) && this.tryPlacing(pos, newstate = (BlockState)state.m_61122_((Property)BlockStateProperties.f_61373_), world, stack, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_) && this.tryPlacing(pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61374_), world, stack, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61365_) && this.tryPlacing(pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61365_), world, stack, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61364_) && this.tryPlacing(pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61364_), world, stack, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_60734_() instanceof SlabBlock) {
            BlockState newState = state;
            if (((SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)).equals((Object)SlabType.DOUBLE)) {
                return InteractionResult.PASS;
            }
            if (((SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)).equals((Object)SlabType.BOTTOM)) {
                newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.TOP);
            }
            if (((SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)).equals((Object)SlabType.TOP)) {
                newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.BOTTOM);
            }
            if (this.tryPlacing(pos, newState, world, stack, player, hand)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        return this.rotate(context.m_8083_(), context.m_43725_().m_8055_(context.m_8083_()), context.m_43725_(), context.m_43722_(), Optional.ofNullable(context.m_43723_()), Optional.of(context.m_43724_()));
    }

    public void dispenserUse(Level world, BlockPos pos, BlockState state, ItemStack stack) {
        this.rotate(pos, state, world, stack, Optional.empty(), Optional.empty());
    }
}

