/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import architectspalette.core.registry.APSounds;
import architectspalette.core.registry.MiscRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architects_palette", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProjectileImpactEventHandler {
    @SubscribeEvent
    public static void projectileImpact(ProjectileImpactEvent event) {
        HitResult hitResult;
        Projectile projectile = event.getProjectile();
        if (projectile.m_20184_().m_82553_() > 0.2 && (hitResult = event.getRayTraceResult()) instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            BlockState state = projectile.m_9236_().m_8055_(hitResult2.m_82425_());
            if (state.m_204336_(MiscRegistry.WIZARD_BLOCKS)) {
                BlockHitResult check;
                Vec3 a;
                Vec3 motion;
                double dot;
                Vec3 stairsVector;
                event.setCanceled(true);
                Vec3 normal = Vec3.m_82528_((Vec3i)hitResult2.m_82434_().m_122436_());
                if (state.m_60734_() instanceof StairBlock && (stairsVector = ProjectileImpactEventHandler.doStairsMath(hitResult2.m_82434_(), state)) != null) {
                    normal = normal.m_82549_(stairsVector).m_82541_();
                }
                if (-(dot = (motion = projectile.m_20184_()).m_82526_(normal)) > 0.05) {
                    dot += 0.05;
                }
                if ((a = normal.m_82490_(-dot * 2.0)).m_82553_() < 0.05 && hitResult2.m_82434_() == Direction.UP) {
                    event.setCanceled(false);
                } else {
                    projectile.m_20256_(motion.m_82549_(a));
                }
                Vec3 vec3 = projectile.m_20184_();
                double d0 = vec3.m_165924_();
                float xrot = (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.29577951308232);
                float yrot = (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.29577951308232);
                Vec3 hit = projectile.m_20182_();
                projectile.m_19890_(hit.f_82479_, hit.f_82480_, hit.f_82481_, yrot, xrot);
                hit = event.getRayTraceResult().m_82450_().m_82549_(normal.m_82490_(0.02));
                if (projectile.f_19853_.f_46443_) {
                    projectile.f_19853_.m_7106_((ParticleOptions)MiscRegistry.WIZARDLY_DEFENSE_BLAST.get(), hit.f_82479_, hit.f_82480_, hit.f_82481_, normal.f_82479_, normal.f_82480_, normal.f_82481_);
                    projectile.f_19853_.m_7785_(hit.f_82479_, hit.f_82480_, hit.f_82481_, (SoundEvent)APSounds.WIZARD_BLAST.get(), SoundSource.BLOCKS, 0.5f, projectile.f_19853_.f_46441_.m_188501_() * 0.4f + 0.8f, false);
                }
                if ((check = projectile.f_19853_.m_45547_(new ClipContext(projectile.m_20182_(), projectile.m_20182_().m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)projectile))).m_6662_() != HitResult.Type.MISS && !check.m_82436_() && check.m_82425_() != hitResult2.m_82425_()) {
                    projectile.m_146884_(check.m_82450_().m_82546_(vec3.m_82490_(1.1)));
                }
            }
        }
    }

    private static Vec3 doStairsMath(Direction direction, BlockState state) {
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        Vec3 e = null;
        if (direction == ((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122424_()) {
            Vec3 vec3 = e = half == Half.BOTTOM ? new Vec3(0.0, 1.0, 0.0) : new Vec3(0.0, -1.0, 0.0);
        }
        if (direction == Direction.UP && half == Half.BOTTOM || direction == Direction.DOWN && half == Half.TOP) {
            e = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122424_().m_122436_());
        }
        return e;
    }
}

