/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import architectspalette.core.model.BoardModel;
import architectspalette.core.model.util.SpriteShift;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ElementsModel;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architects_palette", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterModelLoadersEventHandler {
    public static final String MODELTYPE_BOARDS = "boards";

    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("wrapped", (IGeometryLoader)new WrappedModelLoader());
    }

    static {
        WrappedModelLoader.register(MODELTYPE_BOARDS, new ModelWrapper(){

            @Override
            public BakedModelWrapper<?> apply(IGeometryBakingContext context, BakedModel bakedModel, BlockModel blockModel) {
                ResourceLocation particle = blockModel.m_111480_("particle").m_119203_();
                ResourceLocation odd = new ResourceLocation(particle.m_135827_(), particle.m_135815_() + "_odd");
                return new BoardModel(bakedModel, SpriteShift.getShift(particle, odd));
            }
        });
    }

    private static class WrappedModelLoader
    implements IGeometryLoader<WrappedUnbakedModel> {
        private static final ElementsModel.Loader LOADER = ElementsModel.Loader.INSTANCE;
        private static final Map<String, ModelWrapper> wrappers = new HashMap<String, ModelWrapper>();

        private WrappedModelLoader() {
        }

        private static void register(String name, ModelWrapper wrappingFunction) {
            wrappers.put(name, wrappingFunction);
        }

        public WrappedUnbakedModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            JsonObject wrappedModel = jsonObject.get("wrapped_model").getAsJsonObject();
            String wrapperType = jsonObject.get("wrapper_type").getAsString();
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)wrappedModel, BlockModel.class);
            return new WrappedUnbakedModel(baseModel, wrappers.get(wrapperType));
        }
    }

    private static abstract class ModelWrapper {
        private ModelWrapper() {
        }

        public abstract BakedModelWrapper<?> apply(IGeometryBakingContext var1, BakedModel var2, BlockModel var3);
    }

    private static class WrappedUnbakedModel
    implements IUnbakedGeometry<WrappedUnbakedModel> {
        private final BlockModel wrappedModel;
        private final ModelWrapper wrapper;

        public WrappedUnbakedModel(BlockModel modelToWrap, ModelWrapper func) {
            this.wrappedModel = modelToWrap;
            this.wrapper = func;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel baked = this.wrappedModel.m_111449_(bakery, this.wrappedModel, spriteGetter, modelState, modelLocation, context.useBlockLight());
            return this.wrapper.apply(context, baked, this.wrappedModel);
        }

        public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.wrappedModel.m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

