/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.ite.mixin;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TridentItem.class})
public class MixTridentItem {
    @Unique
    TridentItem tridentItem$that = (TridentItem)this;

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")}, cancellable=true)
    public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        ci.cancel();
        if (user instanceof Player) {
            Player player = (Player)user;
            int i = this.tridentItem$that.m_8105_(stack) - remainingUseTicks;
            if (i >= 10) {
                int j = EnchantmentHelper.m_44932_((ItemStack)stack);
                if (!world.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(user.m_7655_()));
                    if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44957_, (ItemStack)stack) == 0) {
                        this.tridentItem$createTrident(stack, world, player);
                    }
                    if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44957_, (ItemStack)stack) > 0) {
                        if (player.m_20070_() && player.m_6144_()) {
                            this.tridentItem$createTrident(stack, world, player);
                        } else if (!player.m_20070_()) {
                            this.tridentItem$createTrident(stack, world, player);
                        }
                    }
                }
                if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44957_, (ItemStack)stack) > 0 && player.m_20070_() && !player.m_6144_()) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this.tridentItem$that));
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.f_12519_ : (j == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    world.m_6269_(null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void use(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        cir.cancel();
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)itemStack));
        } else {
            user.m_6672_(hand);
            cir.setReturnValue((Object)InteractionResultHolder.m_19096_((Object)itemStack));
        }
    }

    @Unique
    private void tridentItem$createTrident(ItemStack stack, Level world, Player player) {
        ThrownTrident throwntrident = new ThrownTrident(world, (LivingEntity)player, stack);
        throwntrident.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
        if (player.m_150110_().f_35937_) {
            throwntrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        world.m_7967_((Entity)throwntrident);
        world.m_6269_(null, (Entity)throwntrident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_) {
            player.m_150109_().m_36057_(stack);
        }
    }
}

