/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class SanguineArmorModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private static final Map<Integer, SanguineArmorModel<? extends LivingEntity>> CACHE = new HashMap<Integer, SanguineArmorModel<? extends LivingEntity>>();
    public ModelPart helmet;
    public ModelPart chestplate;
    public ModelPart leggingsLeft;
    public ModelPart leggingsRight;
    public ModelPart bootsLeft;
    public ModelPart bootsRight;
    public ModelPart shoulderPadRight;
    public ModelPart shoulderPadLeft;
    private final EquipmentSlot slot;
    private final byte entityFlag;

    public SanguineArmorModel(int entityFlag, ModelPart root) {
        super(root);
        this.slot = EquipmentSlot.values()[entityFlag & 0xF];
        this.entityFlag = (byte)(entityFlag >> 4);
        this.helmet = root.m_171324_("helmet");
        this.chestplate = root.m_171324_("chestplate");
        this.leggingsLeft = root.m_171324_("leggingsLeft");
        this.leggingsRight = root.m_171324_("leggingsRight");
        this.bootsLeft = root.m_171324_("bootsLeft");
        this.bootsRight = root.m_171324_("bootsRight");
        this.shoulderPadRight = root.m_171324_("shoulderPadRight");
        this.shoulderPadLeft = root.m_171324_("shoulderPadLeft");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition helmet = root.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(1, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.6f)).m_171514_(38, 1).m_171488_(-6.9f, -11.55f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.25f)).m_171514_(47, 1).m_171488_(4.9f, -11.55f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chestplate = root.m_171599_("chestplate", CubeListBuilder.m_171558_().m_171514_(37, 13).m_171488_(-4.0f, 0.0f, -2.5f, 8.0f, 14.0f, 5.0f, new CubeDeformation(0.3f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leggingsLeft = root.m_171599_("leggingsLeft", CubeListBuilder.m_171558_().m_171514_(56, 34).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leggingsRight = root.m_171599_("leggingsRight", CubeListBuilder.m_171558_().m_171514_(39, 34).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bootsLeft = root.m_171599_("bootsLeft", CubeListBuilder.m_171558_().m_171514_(81, 16).m_171480_().m_171488_(-2.0f, 6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bootsRight = root.m_171599_("bootsRight", CubeListBuilder.m_171558_().m_171514_(64, 16).m_171488_(-2.0f, 6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition shoulderPadRight = root.m_171599_("shoulderPadRight", CubeListBuilder.m_171558_().m_171514_(6, 19).m_171488_(-4.0f, -2.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.3f)).m_171514_(58, 3).m_171488_(-4.2f, -5.4f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition shoulderPadLeft = root.m_171599_("shoulderPadLeft", CubeListBuilder.m_171558_().m_171514_(6, 32).m_171480_().m_171488_(-1.0f, -2.0f, -3.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.3f)).m_171480_().m_171514_(67, 3).m_171488_(2.2f, -5.4f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public SanguineArmorModel(int entityFlag) {
        this(entityFlag, SanguineArmorModel.createBodyLayer().m_171564_());
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        boolean child;
        boolean bl = child = (this.entityFlag & 4) > 0;
        if (this.slot == EquipmentSlot.HEAD) {
            matrixStack.m_85836_();
            this.helmet.m_104315_(this.f_102808_);
            if (child) {
                matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
                this.helmet.m_104227_(0.0f, 15.0f, 0.0f);
            }
            this.helmet.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
        }
        if (this.slot == EquipmentSlot.CHEST) {
            matrixStack.m_85836_();
            this.chestplate.m_104315_(this.f_102810_);
            this.shoulderPadLeft.m_104315_(this.f_102812_);
            this.shoulderPadRight.m_104315_(this.f_102811_);
            if (child) {
                matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                this.chestplate.m_104227_(0.0f, 24.0f, 0.0f);
                this.shoulderPadLeft.m_104227_(5.0f, 24.0f, 0.0f);
                this.shoulderPadRight.m_104227_(-5.0f, 24.0f, 0.0f);
            }
            this.shoulderPadLeft.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.shoulderPadRight.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.chestplate.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
        }
        if (this.slot == EquipmentSlot.LEGS) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.01f, 1.0f, 1.01f);
            this.leggingsLeft.m_104315_(this.f_102814_);
            this.leggingsRight.m_104315_(this.f_102813_);
            if (child) {
                matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                this.leggingsLeft.m_104227_(2.0f, 36.0f, 0.0f);
                this.leggingsRight.m_104227_(-2.0f, 36.0f, 0.0f);
            }
            this.leggingsLeft.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.leggingsRight.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
        }
        if (this.slot == EquipmentSlot.FEET) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.05f, 1.0f, 1.05f);
            this.bootsLeft.m_104315_(this.f_102814_);
            this.bootsRight.m_104315_(this.f_102813_);
            if (child) {
                matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                this.bootsLeft.m_104227_(2.0f, 37.0f, 0.0f);
                this.bootsRight.m_104227_(-2.0f, 37.0f, 0.0f);
            }
            this.bootsLeft.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bootsRight.m_104306_(matrixStack, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
        }
    }

    public static HumanoidModel<?> getModel(EquipmentSlot slot, LivingEntity entity) {
        int entityFlag = slot.ordinal() & 0xF | 0 | 0 | (entity.m_6162_() ? 1 : 0) << 6;
        return CACHE.computeIfAbsent(entityFlag, SanguineArmorModel::new);
    }
}

