/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.entity.decoration;

import com.teamabnormals.caverns_and_chasms.common.entity.animal.CopperGolem;
import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;

public class OxidizedCopperGolem
extends LivingEntity {
    private static final List<ItemStack> EMPTY_LIST = Collections.emptyList();
    private static final EntityDataAccessor<Boolean> DAMAGED = SynchedEntityData.m_135353_(OxidizedCopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAXED = SynchedEntityData.m_135353_(OxidizedCopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isNoAi;
    private boolean persistenceRequired;
    public long lastHit;

    public OxidizedCopperGolem(EntityType<? extends OxidizedCopperGolem> entity, Level level) {
        super(entity, level);
        this.f_19793_ = 0.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGED, (Object)false);
        this.f_19804_.m_135372_(WAXED, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_DEATH.get();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("NoAI", this.isNoAi());
        compound.m_128379_("PersistenceRequired", this.isPersistenceRequired());
        compound.m_128379_("Damaged", this.isDamaged());
        compound.m_128379_("Waxed", this.isWaxed());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setNoAi(compound.m_128471_("NoAI"));
        this.setPersistenceRequired(compound.m_128471_("PersistenceRequired"));
        this.setDamaged(compound.m_128471_("Damaged"));
        this.setWaxed(compound.m_128471_("Waxed"));
    }

    public InteractionResult m_7111_(Player player, Vec3 pos, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        boolean success = false;
        if (item == Items.f_42784_) {
            if (!this.isWaxed()) {
                this.setWaxed(true);
                this.spawnSparkParticles((ParticleOptions)ParticleTypes.f_175828_);
                this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144178_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                success = true;
            }
        } else if (itemstack.m_41720_() instanceof AxeItem) {
            if (this.isWaxed()) {
                this.setWaxed(false);
                this.spawnSparkParticles((ParticleOptions)ParticleTypes.f_175829_);
                this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144060_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                success = true;
            } else {
                this.deoxidize(CopperGolem.Oxidation.WEATHERED);
                this.spawnSparkParticles((ParticleOptions)ParticleTypes.f_175831_);
                this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144059_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.m_146850_(GameEvent.f_223708_);
                success = true;
            }
            if (success && !this.f_19853_.f_46443_) {
                itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            }
        }
        return success ? InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_) : InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            Entity directentity = source.m_7640_();
            if (DamageSource.f_19317_.equals(source)) {
                this.removeStatue();
                return false;
            }
            if (!this.m_6673_(source)) {
                if (source.m_19372_()) {
                    this.breakStatue(source, true, false);
                    return false;
                }
                if ("player".equals(source.m_19385_()) && directentity instanceof Player && ((Player)directentity).m_150110_().f_35938_) {
                    if (source.m_19390_()) {
                        this.breakStatue(source, false, false);
                        return true;
                    }
                    if (((Player)directentity).m_21205_().canPerformAction(ToolActions.PICKAXE_DIG)) {
                        if (this.isDamaged()) {
                            this.breakStatue(source, true, true);
                        } else {
                            this.setDamaged(true);
                            this.m_146852_(GameEvent.f_223706_, directentity);
                            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144117_, this.m_5720_(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
        CopperGolem coppergolem = this.deoxidize(CopperGolem.Oxidation.UNAFFECTED);
        if (coppergolem != null) {
            coppergolem.spinHead();
            this.f_19853_.m_7605_((Entity)coppergolem, (byte)5);
        }
    }

    private void breakStatue(DamageSource source, boolean dropLoot, boolean brokenWithPickaxe) {
        if (dropLoot) {
            if (brokenWithPickaxe) {
                ItemStack itemstack = this.isWaxed() ? new ItemStack((ItemLike)CCItems.WAXED_OXIDIZED_COPPER_GOLEM.get()) : new ItemStack((ItemLike)CCItems.OXIDIZED_COPPER_GOLEM.get());
                CompoundTag compound = itemstack.m_41784_();
                if (this.m_8077_()) {
                    itemstack.m_41714_(this.m_7770_());
                }
                if (this.isNoAi()) {
                    compound.m_128379_("NoAI", true);
                }
                if (this.m_20067_()) {
                    compound.m_128379_("Silent", true);
                }
                if (this.m_20068_()) {
                    compound.m_128379_("NoGravity", true);
                }
                if (this.m_146886_()) {
                    compound.m_128379_("Glowing", true);
                }
                if (this.m_20147_()) {
                    compound.m_128379_("Invulnerable", true);
                }
                if (this.isPersistenceRequired()) {
                    compound.m_128379_("PersistenceRequired", true);
                }
                Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (ItemStack)itemstack);
            } else {
                this.m_6668_(source);
            }
        }
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152501_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144117_, this.m_5720_(), 1.0f, 1.0f);
        this.m_146850_(GameEvent.f_223707_);
        this.removeStatue();
    }

    private void removeStatue() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public CopperGolem deoxidize(CopperGolem.Oxidation oxidation) {
        if (!this.m_213877_()) {
            CopperGolem coppergolem = (CopperGolem)((EntityType)CCEntityTypes.COPPER_GOLEM.get()).m_20615_(this.f_19853_);
            coppergolem.m_20359_((Entity)this);
            coppergolem.m_5616_(this.m_146908_());
            coppergolem.m_5618_(this.m_146908_());
            coppergolem.m_21557_(this.isNoAi());
            coppergolem.m_20225_(this.m_20067_());
            coppergolem.m_20242_(this.m_20068_());
            coppergolem.m_146915_(this.m_146886_());
            coppergolem.m_20331_(this.m_20147_());
            coppergolem.setOxidation(oxidation);
            coppergolem.setWaxed(this.isWaxed());
            if (this.isDamaged()) {
                coppergolem.m_21153_(coppergolem.m_21233_() * 0.5f - 1.0f);
            }
            if (this.isPersistenceRequired()) {
                coppergolem.m_21530_();
            }
            if (this.m_8077_()) {
                coppergolem.m_6593_(this.m_7770_());
                coppergolem.m_20340_(this.m_20151_());
            }
            this.f_19853_.m_7967_((Entity)coppergolem);
            if (this.m_20159_()) {
                Entity entity = this.m_20202_();
                this.m_8127_();
                coppergolem.m_7998_(entity, true);
            }
            this.m_146870_();
            return coppergolem;
        }
        return null;
    }

    public boolean isDamaged() {
        return (Boolean)this.f_19804_.m_135370_(DAMAGED);
    }

    public void setDamaged(boolean damaged) {
        this.f_19804_.m_135381_(DAMAGED, (Object)damaged);
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(WAXED, (Object)waxed);
    }

    private void spawnSparkParticles(ParticleOptions particle) {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 7; ++i) {
                double d0 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                double d1 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                double d2 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                this.f_19853_.m_7106_(particle, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    public boolean isNoAi() {
        return this.isNoAi;
    }

    public void setNoAi(boolean noAi) {
        this.isNoAi = noAi;
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.persistenceRequired = persistenceRequired;
    }

    public Iterable<ItemStack> m_6168_() {
        return EMPTY_LIST;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.8f;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    protected float m_5632_(float yRot, float xRot) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    public void m_5618_(float rot) {
        this.f_20884_ = this.f_19859_ = rot;
        this.f_20886_ = this.f_20885_ = rot;
    }

    public void m_5616_(float rot) {
        this.f_20884_ = this.f_19859_ = rot;
        this.f_20886_ = this.f_20885_ = rot;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)CCItems.OXIDIZED_COPPER_GOLEM.get());
    }
}

