/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.entity.monster;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import com.teamabnormals.caverns_and_chasms.common.recipe.MimingRecipe;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.caverns_and_chasms.core.registry.CCParticleTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCRecipes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;

public class Mime
extends Monster {
    private static final UUID SPEED_MODIFIER_SNEAKING_UUID = UUID.fromString("D0DEF8EE-3E50-4FFC-A20D-3B9B27F4A3F3");
    private static final AttributeModifier SPEED_MODIFIER_SNEAKING = new AttributeModifier(SPEED_MODIFIER_SNEAKING_UUID, "Sneaking speed boost", (double)-0.3f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final EntityDimensions STANDING_SIZE = EntityDimensions.m_20395_((float)0.6f, (float)2.1f);
    private static final Map<Pose, EntityDimensions> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.SWIMMING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)1.8f)).build();
    public final Vector3f[] armPositions = new Vector3f[]{new Vector3f(-5.0f, 2.0f, 0.0f), new Vector3f(5.0f, 2.0f, 0.0f)};
    public final Vector3f[] armRotations = new Vector3f[]{Vector3f.f_176763_, Vector3f.f_176763_};
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    public float prevCameraYaw;
    public float cameraYaw;
    private int copyTime;

    public Mime(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        Arrays.fill(this.f_21347_, 0.0f);
        Arrays.fill(this.f_21348_, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, false));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public static boolean checkMimeSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() <= 48 && (random.m_188503_(10) == 0 || pos.m_123342_() <= 0) && Mime.checkUndergroundMonsterSpawnRules(type, level, reason, pos, random);
    }

    public static boolean checkUndergroundMonsterSpawnRules(EntityType<? extends Monster> monster, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource p_219018_) {
        return level.m_46791_() != Difficulty.PEACEFUL && Mime.isDarkEnoughToSpawnNoSkylight(level, pos, p_219018_) && Mime.m_217057_(monster, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)p_219018_);
    }

    public static boolean isDarkEnoughToSpawnNoSkylight(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.SKY, pos) > 0) {
            return false;
        }
        DimensionType dimension = level.m_6042_();
        int i = dimension.m_223570_();
        if (i < 15 && level.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.m_6018_().m_46470_() ? level.m_46849_(pos, 10) : level.m_46803_(pos);
        return j <= dimension.m_223569_().m_214085_(random);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CCSoundEvents.ENTITY_MIME_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CCSoundEvents.ENTITY_MIME_HURT.get();
    }

    protected void m_7472_(DamageSource source, int p_34292_, boolean p_34293_) {
        ItemStack itemstack;
        Creeper creeper;
        super.m_7472_(source, p_34292_, p_34293_);
        Entity entity = source.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_() && !(itemstack = this.getSkull()).m_41619_()) {
            creeper.m_32314_();
            this.m_19983_(itemstack);
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)CCItems.MIME_HEAD.get());
    }

    public boolean m_7327_(Entity entityIn) {
        boolean result = super.m_7327_(entityIn);
        if (entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            boolean mimed = false;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack stack = entity.m_6844_(slot);
                if (!this.shouldCopyItem(this.m_6844_(slot), stack)) continue;
                this.m_8061_(slot, stack.m_41777_());
                mimed = true;
            }
            if (mimed) {
                this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_MIME_IMPERSONATE.get(), 1.0f, 1.0f);
            }
        }
        return result;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        Entity source = cause.m_7639_();
        if (!this.f_19853_.m_5776_() && source instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)source;
            ItemStack stack = attacker.m_6844_(EquipmentSlot.OFFHAND);
            List recipes = this.f_19853_.m_7465_().m_44013_((RecipeType)CCRecipes.CCRecipeTypes.MIMING.get());
            for (MimingRecipe recipe : recipes) {
                for (Ingredient ingredient : recipe.m_7527_()) {
                    if (stack.m_41613_() != 1 || !ingredient.test(stack)) continue;
                    attacker.m_8061_(EquipmentSlot.OFFHAND, recipe.m_8043_().m_41777_());
                    source.m_5496_((SoundEvent)CCSoundEvents.ENTITY_MIME_MIME.get(), 1.0f, 1.0f);
                    return;
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateCape();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.f_19853_.f_46443_) {
                if (this.f_19796_.m_188503_(5) == 0) {
                    int i = this.f_19796_.m_188503_(2);
                    float f = -Mth.m_14179_((float)this.m_20998_(0.0f), (float)0.0f, (float)(this.m_20069_() ? -90.0f - this.m_146909_() : -90.0f)) * ((float)Math.PI / 180);
                    float f1 = (180.0f - this.f_20883_) * ((float)Math.PI / 180);
                    float yaw = this.armRotations[i].m_122239_();
                    float pitch = this.armRotations[i].m_122260_();
                    float roll = this.armRotations[i].m_122269_();
                    float x = i == 0 ? 0.0625f : -0.0625f;
                    float y = -0.71875f;
                    float x1 = Mth.m_14089_((float)pitch) * Mth.m_14089_((float)roll) * x + (Mth.m_14031_((float)yaw) * Mth.m_14031_((float)pitch) * Mth.m_14089_((float)roll) - Mth.m_14089_((float)yaw) * Mth.m_14031_((float)roll)) * y;
                    float y1 = Mth.m_14089_((float)pitch) * Mth.m_14031_((float)roll) * x + (Mth.m_14031_((float)yaw) * Mth.m_14031_((float)pitch) * Mth.m_14031_((float)roll) + Mth.m_14089_((float)yaw) * Mth.m_14089_((float)roll)) * y;
                    float z1 = Mth.m_14031_((float)pitch) * x - Mth.m_14031_((float)yaw) * Mth.m_14089_((float)pitch) * y;
                    Vec3 vec3 = new Vec3((double)x1, (double)y1, (double)z1).m_82549_(new Vec3(this.armPositions[i]).m_82490_(-0.0625)).m_82520_(0.0, 1.5, 0.0);
                    vec3 = vec3.m_82496_(f);
                    if (this.m_6067_()) {
                        vec3 = vec3.m_82520_(0.0, 0.3, 1.0);
                    }
                    vec3 = vec3.m_82524_(f1);
                    double d0 = (double)this.f_19796_.m_188501_() * 0.1 - 0.05;
                    double d1 = (double)this.f_19796_.m_188501_() * 0.1 - 0.05;
                    double d2 = (double)this.f_19796_.m_188501_() * 0.1 - 0.05;
                    this.f_19853_.m_7106_((ParticleOptions)CCParticleTypes.MIME_ENERGY.get(), this.m_20185_() + vec3.m_7096_() + d0, this.m_20186_() + vec3.m_7098_() + d1, this.m_20189_() + vec3.m_7094_() + d2, 0.0, 0.0, 0.0);
                }
            } else {
                Pose pose;
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.copyMainArm(target);
                    if (target.f_20911_ && !this.f_20911_) {
                        this.m_6674_(target.f_20912_);
                    }
                    if (this.copyTime > 0) {
                        --this.copyTime;
                        if (this.copyTime == 0) {
                            boolean mimed = false;
                            if (this.shouldCopyItem(this.m_21205_(), target.m_21205_())) {
                                this.m_8061_(EquipmentSlot.MAINHAND, target.m_21205_().m_41777_());
                                mimed = true;
                            }
                            if (this.shouldCopyItem(this.m_21206_(), target.m_21206_())) {
                                this.m_8061_(EquipmentSlot.OFFHAND, target.m_21206_().m_41777_());
                                mimed = true;
                            }
                            if (mimed) {
                                this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)CCSoundEvents.ENTITY_MIME_MIME.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                            }
                        }
                    } else if (this.shouldCopyItem(this.m_21205_(), target.m_21205_()) || this.shouldCopyItem(this.m_21206_(), target.m_21206_())) {
                        this.copyTime = this.f_19796_.m_188503_(3) + 4;
                    }
                } else {
                    this.copyTime = 0;
                }
                Pose pose2 = pose = target != null ? target.m_20089_() : Pose.STANDING;
                if (!(this.m_20159_() || pose != Pose.SWIMMING && pose != Pose.CROUCHING && pose != Pose.STANDING)) {
                    if (!this.m_20175_(pose)) {
                        pose = this.m_20175_(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING;
                    }
                } else {
                    pose = Pose.STANDING;
                }
                this.m_20124_(pose);
                this.handleSneakingSpeed();
                this.m_6858_((this.f_19853_.m_46791_() == Difficulty.NORMAL || this.f_19853_.m_46791_() == Difficulty.HARD) && target != null && target.m_20142_());
            }
        }
    }

    private boolean shouldCopyItem(ItemStack currentStack, ItemStack targetStack) {
        if (currentStack.m_41619_() != targetStack.m_41619_()) {
            return true;
        }
        if (currentStack.m_41763_() != targetStack.m_41763_()) {
            return true;
        }
        ItemStack itemstack = targetStack.m_41777_();
        itemstack.m_41764_(currentStack.m_41613_());
        if (currentStack.m_41763_()) {
            itemstack.m_41721_(currentStack.m_41773_());
        }
        return !ItemStack.m_41728_((ItemStack)currentStack, (ItemStack)itemstack);
    }

    private void copyMainArm(LivingEntity entity) {
        if (this.m_5737_() != entity.m_5737_()) {
            this.m_21559_(!this.m_21526_());
        }
    }

    private void handleSneakingSpeed() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (attributeinstance.m_22111_(SPEED_MODIFIER_SNEAKING_UUID) != null) {
            attributeinstance.m_22130_(SPEED_MODIFIER_SNEAKING);
        }
        if (this.m_6047_() || this.m_20143_()) {
            attributeinstance.m_22118_(SPEED_MODIFIER_SNEAKING);
        }
    }

    public boolean m_20161_() {
        return this.m_20089_() == Pose.CROUCHING || super.m_20161_();
    }

    public double m_6049_() {
        return -0.45;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return SIZE_BY_POSE.getOrDefault(pose, STANDING_SIZE);
    }

    private void updateCape() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.m_20185_() - this.chasingPosX;
        double d1 = this.m_20186_() - this.chasingPosY;
        double d2 = this.m_20189_() - this.chasingPosZ;
        if (d0 > 10.0) {
            this.chasingPosX = this.m_20185_();
        }
        if (d2 > 10.0) {
            this.chasingPosZ = this.m_20189_();
        }
        if (d1 > 10.0) {
            this.chasingPosY = this.m_20186_();
        }
        if (d0 < -10.0) {
            this.chasingPosX = this.m_20185_();
        }
        if (d2 < -10.0) {
            this.chasingPosZ = this.m_20189_();
        }
        if (d1 < -10.0) {
            this.chasingPosY = this.m_20186_();
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
    }
}

