/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.entity.monster;

import com.teamabnormals.caverns_and_chasms.common.entity.ai.goal.PeeperSwellGoal;
import com.teamabnormals.caverns_and_chasms.common.entity.monster.MovingPlayer;
import com.teamabnormals.caverns_and_chasms.core.other.CCCriteriaTriggers;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class Peeper
extends Creeper {
    private static final UUID FREEZE_MODIFIER_UUID = UUID.fromString("113f0691-d920-423d-acd2-9ca0c577991f");
    private static final UUID SPEED_UP_MODIFIER_UUID = UUID.fromString("6866925d-f410-42b9-b2f2-7a22c60a6380");
    private static final AttributeModifier FREEZE_MODIFIER = new AttributeModifier(FREEZE_MODIFIER_UUID, "Peeper frozen", -100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private int followingTicks;

    public Peeper(EntityType<? extends Peeper> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PeeperSwellGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CCSoundEvents.ENTITY_DEEPER_HURT.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CCSoundEvents.ENTITY_DEEPER_DEATH.get();
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            LivingEntity livingEntity;
            AttributeInstance speedAttribute = this.m_21051_(Attributes.f_22279_);
            if (speedAttribute.m_22111_(FREEZE_MODIFIER_UUID) != null) {
                speedAttribute.m_22120_(FREEZE_MODIFIER_UUID);
            }
            if ((livingEntity = this.m_5448_()) instanceof MovingPlayer) {
                MovingPlayer player = (MovingPlayer)livingEntity;
                if (!player.isMoving()) {
                    speedAttribute.m_22118_(FREEZE_MODIFIER);
                    this.m_21563_().m_24946_(this.m_5448_().m_20185_(), this.m_5448_().m_20188_(), this.m_5448_().m_20189_());
                } else {
                    ++this.followingTicks;
                    speedAttribute.m_22120_(SPEED_UP_MODIFIER_UUID);
                    speedAttribute.m_22118_(new AttributeModifier(SPEED_UP_MODIFIER_UUID, "Peeper speed boost", Math.min((double)this.followingTicks * 4.0E-4, 0.23), AttributeModifier.Operation.ADDITION));
                }
            }
            if (this.m_5448_() == null) {
                speedAttribute.m_22120_(SPEED_UP_MODIFIER_UUID);
            }
            this.f_32269_ = this.f_32270_;
            if (this.m_32311_()) {
                this.m_32283_(1);
            }
            if ((i = this.m_32310_()) > 0 && this.f_32270_ == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.f_32270_ += i;
            if (this.f_32270_ < 0) {
                this.f_32270_ = 0;
            }
            if (this.f_32270_ >= this.f_32271_) {
                this.f_32270_ = this.f_32271_;
                this.m_32315_();
            }
        } else if (this.f_32270_ > 0) {
            --this.f_32270_;
        }
        super.m_8119_();
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            CCCriteriaTriggers.SPOTTED_BY_PEEPER.trigger(player);
        }
    }

    public void m_32315_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            Explosion.BlockInteraction explosion$mode = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.f_32272_ * f, this.m_6060_(), explosion$mode);
            this.m_146870_();
            this.m_32316_();
        }
    }

    protected void m_7472_(DamageSource source, int p_34292_, boolean p_34293_) {
        ItemStack itemstack;
        Creeper creeper;
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            boolean flag;
            ItemStack itemstack2 = this.m_6844_(equipmentslot);
            float f = this.m_21519_(equipmentslot);
            boolean bl = flag = f > 1.0f;
            if (itemstack2.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack2) || !p_34293_ && !flag || !(Math.max(this.f_19796_.m_188501_() - (float)p_34292_ * 0.01f, 0.0f) < f)) continue;
            if (!flag && itemstack2.m_41763_()) {
                itemstack2.m_41721_(itemstack2.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(itemstack2.m_41776_() - 3, 1))));
            }
            this.m_19983_(itemstack2);
            this.m_8061_(equipmentslot, ItemStack.f_41583_);
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_() && !(itemstack = this.getSkull()).m_41619_()) {
            creeper.m_32314_();
            this.m_19983_(itemstack);
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)CCItems.PEEPER_HEAD.get());
    }
}

