/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.item;

import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class GoldenBucketItem
extends Item
implements DispensibleContainerItem {
    private static final String NBT_TAG = "FluidLevel";
    private final Supplier<? extends Fluid> fluidSupplier;

    public GoldenBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(builder);
        this.fluidSupplier = supplier;
    }

    public static ItemStack resetFluidLevel(ItemStack stack) {
        stack.m_41784_().m_128405_(NBT_TAG, 0);
        return stack;
    }

    public static void setFluidLevel(ItemStack stack, int level) {
        stack.m_41784_().m_128405_(NBT_TAG, level);
    }

    public static ItemStack decreaseFluidLevel(ItemStack stack) {
        int level = stack.m_41784_().m_128451_(NBT_TAG);
        if (level > 0) {
            stack.m_41784_().m_128405_(NBT_TAG, level - 1);
        }
        return stack;
    }

    public static ItemStack increaseFluidLevel(ItemStack stack) {
        int level = stack.m_41784_().m_128451_(NBT_TAG);
        if (level < 3) {
            stack.m_41784_().m_128405_(NBT_TAG, level + 1);
        }
        return stack;
    }

    public static boolean canBeFilled(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_TAG) < 2;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)GoldenBucketItem.resetFluidLevel(new ItemStack((ItemLike)this)));
        }
    }

    public ItemStack m_7968_() {
        return GoldenBucketItem.resetFluidLevel(new ItemStack((ItemLike)this));
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        GoldenBucketItem.resetFluidLevel(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        int bucketLevel = tag.m_128451_(NBT_TAG);
        BlockHitResult result = GoldenBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(!(this.getFluid() != Fluids.f_76191_ && bucketLevel >= 2 || player.m_6047_() && this.getFluid() != Fluids.f_76191_) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)result);
        if (ret != null) {
            return ret;
        }
        if (result.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = result.m_82425_();
        Direction direction = result.m_82434_();
        BlockPos sourcePos = pos.m_121945_(direction);
        if (level.m_7966_(player, pos) && player.m_36204_(sourcePos, direction, stack)) {
            BlockPos newPos;
            BlockState sourceState = level.m_8055_(pos);
            if (this.getFluid() == Fluids.f_76191_ || bucketLevel < 2 && sourceState.m_60819_().m_76152_() == this.getFluid()) {
                Block block = sourceState.m_60734_();
                if (block instanceof BucketPickup) {
                    BucketPickup bucketPickup = (BucketPickup)block;
                    bucketPickup.m_142598_((LevelAccessor)level, pos, sourceState);
                    FlowingFluid fluid = sourceState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Fluids.f_76193_ : (sourceState.m_60819_().m_192917_((Fluid)Fluids.f_76195_) ? Fluids.f_76195_ : Fluids.f_76191_);
                    ItemStack newBucket = ItemStack.f_41583_;
                    if (fluid != Fluids.f_76191_ && GoldenBucketItem.getFilledBucket(sourceState) != null) {
                        newBucket = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)GoldenBucketItem.getFilledBucket(sourceState));
                        if (this.getFluid() != Fluids.f_76191_) {
                            GoldenBucketItem.setFluidLevel(newBucket, bucketLevel + 1);
                        }
                    }
                    if (sourceState.m_60713_(Blocks.f_152499_)) {
                        newBucket = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)CCItems.GOLDEN_POWDER_SNOW_BUCKET.get()));
                    }
                    if (!newBucket.m_41619_()) {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        bucketPickup.getPickupSound(sourceState).ifPresent(soundEvent -> player.m_5496_(soundEvent, 1.0f, 1.0f));
                        level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
                        if (!level.f_46443_) {
                            CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, newBucket);
                        }
                        return InteractionResultHolder.m_19092_((Object)newBucket, (boolean)level.m_5776_());
                    }
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            result = GoldenBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (result.m_6662_() == HitResult.Type.MISS) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (result.m_6662_() != HitResult.Type.BLOCK) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            pos = result.m_82425_();
            direction = result.m_82434_();
            sourcePos = pos.m_121945_(direction);
            BlockState state = level.m_8055_(pos);
            BlockPos blockPos = newPos = this.canBlockContainFluid(level, pos, state) || this.getFluid() != Fluids.f_76191_ && bucketLevel < 2 ? pos : sourcePos;
            if (this.m_142073_(player, level, newPos, result)) {
                this.checkExtraContent(level, stack, newPos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, newPos, stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)GoldenBucketItem.getEmptySuccessItem(stack, player), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack stack, @Nullable Player player) {
        ItemStack returnStack;
        int level = stack.m_41784_().m_128451_(NBT_TAG);
        ItemStack itemStack = returnStack = level > 0 ? stack : GoldenBucketItem.getEmptyBucket();
        if (player == null || !player.m_150110_().f_35937_) {
            GoldenBucketItem.decreaseFluidLevel(returnStack);
        }
        return player == null || !player.m_150110_().f_35937_ ? returnStack : stack;
    }

    public void checkExtraContent(Level worldIn, ItemStack p_203792_2_, BlockPos pos) {
    }

    public boolean m_142073_(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result) {
        if (!(this.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        Material material = state.m_60767_();
        boolean replaceable = state.m_60722_(this.getFluid());
        if (!(state.m_60795_() || replaceable || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.getFluid()))) {
            return result != null && this.m_142073_(player, level, result.m_82425_().m_121945_(result.m_82434_()), null);
        }
        if (level.m_6042_().f_63857_() && this.getFluid().m_205067_(FluidTags.f_13131_)) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.getFluid())) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)level, pos, state, ((FlowingFluid)this.getFluid()).m_76068_(false));
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.f_46443_ && replaceable && !material.m_76332_()) {
            level.m_46961_(pos, true);
        }
        if (!level.m_7731_(pos, this.getFluid().m_76145_().m_76188_(), 11) && !state.m_60819_().m_76170_()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        SoundEvent soundevent = this.getFluid().getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = this.getFluid().m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        level.m_5594_(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (((Object)((Object)this)).getClass() == GoldenBucketItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.getFluid());
    }

    public static ItemStack getFilledBucket(Fluid fluid) {
        if (fluid == Fluids.f_76193_) {
            return new ItemStack((ItemLike)CCItems.GOLDEN_WATER_BUCKET.get());
        }
        if (fluid == Fluids.f_76195_) {
            return new ItemStack((ItemLike)CCItems.GOLDEN_LAVA_BUCKET.get());
        }
        if (ForgeMod.MILK.isPresent() && fluid == ForgeMod.MILK.get()) {
            return new ItemStack((ItemLike)CCItems.GOLDEN_MILK_BUCKET.get());
        }
        return null;
    }

    public static ItemStack getFilledBucket(BlockState state) {
        if (state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            return new ItemStack((ItemLike)CCItems.GOLDEN_WATER_BUCKET.get());
        }
        if (state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) {
            return new ItemStack((ItemLike)CCItems.GOLDEN_LAVA_BUCKET.get());
        }
        if (state.m_60713_(Blocks.f_152499_)) {
            return new ItemStack((ItemLike)CCItems.GOLDEN_POWDER_SNOW_BUCKET.get());
        }
        if (ForgeMod.MILK.isPresent() && state.m_60819_().m_192917_((Fluid)ForgeMod.MILK.get())) {
            return new ItemStack((ItemLike)CCItems.GOLDEN_MILK_BUCKET.get());
        }
        return null;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        int level = stack.m_41784_().m_128451_(NBT_TAG);
        ItemStack newStack = GoldenBucketItem.getFilledBucket(this.getFluid());
        if (level > 0 && newStack != null) {
            GoldenBucketItem.setFluidLevel(newStack, level - 1);
            return newStack;
        }
        return GoldenBucketItem.getEmptyBucket();
    }

    public int getBurnTime(ItemStack stack, RecipeType<?> recipeType) {
        return stack.m_41720_() == CCItems.GOLDEN_LAVA_BUCKET.get() ? 20000 : super.getBurnTime(stack, recipeType);
    }

    public static ItemStack getEmptyBucket() {
        return GoldenBucketItem.resetFluidLevel(new ItemStack((ItemLike)CCItems.GOLDEN_BUCKET.get()));
    }
}

