/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import com.teamabnormals.caverns_and_chasms.client.model.SanguineArmorModel;
import com.teamabnormals.caverns_and_chasms.core.registry.CCAttributes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class SanguineArmorItem
extends ArmorItem {
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(CCItems.SILVER_BOOTS);

    public SanguineArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.getAttributeModifiers(this.m_40402_(), stack));
        UUID uuid = ArmorItem.f_40380_[slot.m_20749_()];
        builder.put((Object)((Attribute)CCAttributes.LIFESTEAL.get()), (Object)new AttributeModifier(uuid, "Lifesteal", 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        return slot == this.f_40377_ ? builder.build() : super.getAttributeModifiers(slot, stack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem((Item)this, group, items);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "caverns_and_chasms:textures/models/armor/sanguine_armor.png";
    }

    public static void causeHealParticles(LivingEntity entity, float amount) {
        RandomSource random = entity.m_217043_();
        int count = 3;
        for (int i = 0; i < count; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            NetworkUtil.spawnParticle((String)ParticleTypes.f_123750_.m_5942_(), (double)entity.m_20208_(0.75), (double)(entity.m_20188_() + (double)0.1f + random.m_188500_() * (double)0.3f), (double)entity.m_20262_(0.75), (double)d0, (double)d1, (double)d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> properties) {
                return SanguineArmorModel.getModel(slot, entity);
            }
        });
    }
}

