/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.item;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.caverns_and_chasms.common.entity.ControllableGolem;
import com.teamabnormals.caverns_and_chasms.core.other.CCCriteriaTriggers;
import com.teamabnormals.caverns_and_chasms.core.other.CCDataProcessors;
import com.teamabnormals.caverns_and_chasms.core.other.CCGameEvents;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class TuningForkItem
extends Item {
    public TuningForkItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        Player player = context.m_43723_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = context.m_43722_();
        CompoundTag tag = stack.m_41784_();
        if (player != null) {
            if (state.m_60734_() instanceof NoteBlock && player.m_6047_()) {
                int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
                if (!tag.m_128441_("Note") || tag.m_128451_("Note") != note) {
                    tag.m_128405_("Note", ((Integer)state.m_61143_((Property)NoteBlock.f_55013_)).intValue());
                    player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".capture_note"), (Object[])new Object[]{Component.m_237115_((String)(this.m_5524_() + ".note." + note))}).m_130946_(" (" + note + ")"), true);
                    TuningForkItem.playNote(level, (Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), note);
                    if (player instanceof ServerPlayer) {
                        CCCriteriaTriggers.USE_TUNING_FORK.trigger((ServerPlayer)player);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (tag.m_128441_("Note")) {
                BlockPos targetpos = state.m_60812_((BlockGetter)level, pos).m_83281_() ? pos : pos.m_121945_(direction);
                int note = tag.m_128451_("Note");
                player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".note")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".note." + note))).m_130946_(" (" + note + ")"), true);
                TuningForkItem.playNote(level, (Entity)player, (double)targetpos.m_123341_() + 0.5, (double)targetpos.m_123342_() + 0.5, (double)targetpos.m_123343_() + 0.5, note);
                if (level.f_46443_) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)targetpos.m_123341_() + 0.5, (double)targetpos.m_123342_() + 0.25, (double)targetpos.m_123343_() + 0.5, (double)note / 24.0, 0.0, 0.0);
                } else {
                    TuningForkItem.attractGolemToPos(targetpos, player);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Note")) {
            int note = tag.m_128451_("Note");
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".note")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".note." + note))).m_130946_(" (" + note + ")"), true);
            Vec3 vec3 = player.m_146892_().m_82549_(player.m_20252_(1.0f).m_82541_().m_82490_(1.5));
            TuningForkItem.playNote(level, (Entity)player, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), note);
            if (level.f_46443_) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), (double)note / 24.0, 0.0, 0.0);
            } else {
                TuningForkItem.attractGolemToPos(new BlockPos(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_()), player);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        CompoundTag tag = stack.m_41784_();
        int note = tag.m_128451_("Note");
        if (tag.m_128441_("Note")) {
            TuningForkItem.playNote(player.f_19853_, (Entity)player, target.m_20185_(), target.m_20188_(), target.m_20189_(), note);
            if (player.f_19853_.f_46443_) {
                player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, target.m_20185_(), target.m_20188_(), target.m_20189_(), (double)note / 24.0, 0.0, 0.0);
            }
            if (target instanceof ControllableGolem && ((ControllableGolem)target).canBeTuningForkControlled(player)) {
                ControllableGolem golem = (ControllableGolem)target;
                Player originalcontroller = golem.getTuningForkController();
                if (originalcontroller != player) {
                    TuningForkItem.setControlledGolem(player, golem);
                    TuningForkItem.setForgetGolemTime(player, 200);
                    if (originalcontroller != null) {
                        TuningForkItem.setControlledGolem(originalcontroller, null);
                    }
                    golem.setTuningForkPos(null);
                    golem.setTuningForkTarget(null);
                    ((Mob)golem).m_21573_().m_26573_();
                    ((Mob)golem).m_6710_(null);
                    golem.onTuningForkControlStart(player);
                } else {
                    TuningForkItem.setControlledGolem(player, null);
                    golem.onTuningForkControlEnd(player);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".note")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)(this.m_5524_() + ".note." + note))).m_130946_(" (" + note + ")"), true);
                if (!player.f_19853_.f_46443_) {
                    TuningForkItem.attractGolemToPos(target.m_20183_(), player);
                }
            }
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Note")) {
            int note = tag.m_128451_("Note");
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".note." + note)).m_130946_(" (" + note + ")").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static void playNote(Level level, Entity entity, double x, double y, double z, int note) {
        float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        level.m_6263_(null, x, y, z, (SoundEvent)CCSoundEvents.TUNING_FORK_VIBRATE.get(), SoundSource.NEUTRAL, 1.0f, pitch);
        level.m_214171_((GameEvent)CCGameEvents.TUNING_FORK_VIBRATE.get(), new Vec3(x, y, z), GameEvent.Context.m_223717_((Entity)entity));
    }

    public static boolean isTuningForkWithNote(ItemStack stack) {
        return stack.m_41720_() instanceof TuningForkItem && stack.m_41783_() != null && stack.m_41783_().m_128441_("Note");
    }

    public static void setControlledGolem(Player player, ControllableGolem golem) {
        ((IDataManager)player).setValue(CCDataProcessors.CONTROLLED_GOLEM_UUID, golem != null ? Optional.of(((Mob)golem).m_20148_()) : Optional.empty());
    }

    public static ControllableGolem findControlledGolem(Player player) {
        for (Mob mob : player.f_19853_.m_45976_(Mob.class, player.m_20191_().m_82400_(16.0))) {
            ControllableGolem golem;
            if (!(mob instanceof ControllableGolem) || !(golem = (ControllableGolem)mob).isTuningForkControlledBy(player) || !golem.canBeTuningForkControlled(player)) continue;
            return golem;
        }
        return null;
    }

    public static void setForgetGolemTime(Player player, int time) {
        ((IDataManager)player).setValue(CCDataProcessors.FORGET_GOLEM_TIME, (Object)time);
    }

    public static int getForgetGolemTime(Player player) {
        return (Integer)((IDataManager)player).getValue(CCDataProcessors.FORGET_GOLEM_TIME);
    }

    public static void attractGolemToPos(BlockPos pos, Player player) {
        ControllableGolem golem = TuningForkItem.findControlledGolem(player);
        if (golem != null && golem.shouldMoveToTuningForkPos(pos, player)) {
            golem.setTuningForkPos(pos);
            golem.setTuningForkTarget(null);
            ((Mob)golem).m_6710_(null);
        }
    }

    public static void orderGolemToAttackEntity(LivingEntity target, Player player) {
        ControllableGolem golem = TuningForkItem.findControlledGolem(player);
        if (golem != null) {
            if (golem.shouldAttackTuningForkTarget(target, player)) {
                golem.setTuningForkTarget(target);
                golem.setTuningForkPos(null);
            } else if (golem.shouldMoveToTuningForkPos(target.m_20183_(), player)) {
                golem.setTuningForkPos(target.m_20183_());
                golem.setTuningForkTarget(null);
                ((Mob)golem).m_6710_(null);
            }
        }
    }

    public static int getNoteColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Note")) {
            int note = tag.m_128451_("Note");
            float f = (float)note / 24.0f;
            float r = Math.max(0.0f, Mth.m_14031_((float)((f + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float g = Math.max(0.0f, Mth.m_14031_((float)((f + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float b = Math.max(0.0f, Mth.m_14031_((float)((f + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            return ((int)(r * 255.0f) << 16) + ((int)(g * 255.0f) << 8) + (int)(b * 255.0f);
        }
        return -1;
    }
}

