/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.teamabnormals.caverns_and_chasms.core.registry.CCParticleTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SpinelBoom
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private final Level level;
    @Nullable
    private final Entity source;
    private final float radius;
    private final double x;
    private final double y;
    private final double z;
    private final Explosion.BlockInteraction blockInteraction;
    private final ExplosionDamageCalculator damageCalculator;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();

    public SpinelBoom(Level level, @Nullable Entity source, double x, double y, double z, float radius) {
        this(level, source, x, y, z, radius, Explosion.BlockInteraction.DESTROY);
    }

    public SpinelBoom(Level level, @Nullable Entity source, double x, double y, double z, float radius, Explosion.BlockInteraction blockInteraction) {
        super(level, source, null, null, x, y, z, radius, false, blockInteraction);
        this.level = level;
        this.source = source;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockInteraction = blockInteraction;
        this.damageCalculator = this.makeDamageCalculator(source);
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity);
    }

    public void m_46061_() {
        this.level.m_220400_(this.source, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        FluidState fluidstate = this.level.m_6425_(blockpos);
                        if (!this.level.m_46739_(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f) && blockstate.m_60734_() instanceof TntBlock) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f = this.radius * 2.0f;
        int x1 = Mth.m_14107_((double)(this.x - (double)f - 1.0));
        int x2 = Mth.m_14107_((double)(this.x + (double)f + 1.0));
        int y1 = Mth.m_14107_((double)(this.y - (double)f - 1.0));
        int y2 = Mth.m_14107_((double)(this.y + (double)f + 1.0));
        int z1 = Mth.m_14107_((double)(this.z - (double)f - 1.0));
        int z2 = Mth.m_14107_((double)(this.z + (double)f + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f);
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        for (int i = 0; i < list.size(); ++i) {
            Player player;
            double d6;
            double d3;
            double d2;
            double d1;
            double d4;
            double d0;
            Entity entity = (Entity)list.get(i);
            if (entity.m_6128_() || !((d0 = Math.sqrt(entity.m_20238_(vec3)) / (double)f) <= 1.0) || (d4 = Math.sqrt((d1 = entity.m_20185_() - this.x) * d1 + (d2 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d2 + (d3 = entity.m_20189_() - this.z) * d3)) == 0.0) continue;
            d1 /= d4;
            d2 /= d4;
            d3 /= d4;
            double d5 = SpinelBoom.m_46064_((Vec3)vec3, (Entity)entity);
            double d7 = d6 = (1.0 - d0) * d5;
            if (entity instanceof LivingEntity) {
                d7 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d6);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d1 * d7, d2 * d7, d3 * d7));
            entity.f_19864_ = true;
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.hitPlayers.put(player, new Vec3(d1 * d6, d2 * d6, d3 * d6));
        }
    }

    public void m_46075_(boolean spawnParticles) {
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        if (spawnParticles) {
            if (!(this.radius < 2.0f)) {
                this.level.m_7106_((ParticleOptions)CCParticleTypes.SPINEL_BOOM_EMITTER.get(), this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.m_7106_(this.level.f_46441_.m_188499_() ? (ParticleOptions)CCParticleTypes.SPINEL_BOOM_CIRCLE.get() : (ParticleOptions)CCParticleTypes.SPINEL_BOOM_STAR.get(), this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (this.blockInteraction != Explosion.BlockInteraction.NONE) {
            Util.m_214673_(this.toBlow, (RandomSource)this.level.f_46441_);
            for (BlockPos blockpos : this.toBlow) {
                BlockState blockstate = this.level.m_8055_(blockpos);
                this.level.m_46473_().m_6180_("explosion_blocks");
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
        }
    }

    public void m_46080_() {
        this.toBlow.clear();
    }

    public List<BlockPos> m_46081_() {
        return this.toBlow;
    }

    public Map<Player, Vec3> m_46078_() {
        return this.hitPlayers;
    }
}

