/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.network;

import com.google.common.collect.Lists;
import com.teamabnormals.caverns_and_chasms.common.level.SpinelBoom;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class S2CSpinelBoomMessage {
    public float posX;
    public float posY;
    public float posZ;
    public float strength;
    public List<BlockPos> affectedBlockPositions;

    public S2CSpinelBoomMessage(float x, float y, float z, float strength, List<BlockPos> affectedBlockPositions) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.affectedBlockPositions = Lists.newArrayList(affectedBlockPositions);
    }

    public static S2CSpinelBoomMessage deserialize(FriendlyByteBuf buf) {
        float posX = buf.readFloat();
        float posY = buf.readFloat();
        float posZ = buf.readFloat();
        float strength = buf.readFloat();
        int blockPositionsSize = buf.readInt();
        ArrayList affectedBlockPositions = Lists.newArrayListWithCapacity((int)blockPositionsSize);
        for (int i = 0; i < blockPositionsSize; ++i) {
            int x = buf.readByte() + Mth.m_14143_((float)posX);
            int y = buf.readByte() + Mth.m_14143_((float)posY);
            int z = buf.readByte() + Mth.m_14143_((float)posZ);
            affectedBlockPositions.add(new BlockPos(x, y, z));
        }
        return new S2CSpinelBoomMessage(posX, posY, posZ, strength, affectedBlockPositions);
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeFloat(this.posX);
        buf.writeFloat(this.posY);
        buf.writeFloat(this.posZ);
        buf.writeFloat(this.strength);
        buf.writeInt(this.affectedBlockPositions.size());
        for (BlockPos blockpos : this.affectedBlockPositions) {
            int x = blockpos.m_123341_() - Mth.m_14143_((float)this.posX);
            int y = blockpos.m_123342_() - Mth.m_14143_((float)this.posY);
            int z = blockpos.m_123343_() - Mth.m_14143_((float)this.posZ);
            buf.writeByte(x);
            buf.writeByte(y);
            buf.writeByte(z);
        }
    }

    public static void handle(S2CSpinelBoomMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            SpinelBoom boom = new SpinelBoom(player.m_20193_(), null, message.posX, message.posY, message.posZ, message.strength);
            boom.m_46075_(true);
            context.setPacketHandled(true);
        }
    }
}

