/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCBiomeTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBiomeModifierTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCFeatures;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CCBiomeModifierProvider {
    private static final RegistryAccess ACCESS = RegistryAccess.m_206197_();
    private static final Registry<Biome> BIOMES = ACCESS.m_175515_(Registry.f_122885_);
    private static final Registry<PlacedFeature> PLACED_FEATURES = ACCESS.m_175515_(Registry.f_194567_);
    private static final HashMap<ResourceLocation, BiomeModifier> MODIFIERS = new HashMap();

    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        CCBiomeModifierProvider.addSpawn("mime", CCBiomeTags.HAS_MIME, new MobSpawnSettings.SpawnerData((EntityType)CCEntityTypes.MIME.get(), 100, 1, 1));
        CCBiomeModifierProvider.addSpawn("glare", CCBiomeTags.HAS_GLARE, new MobSpawnSettings.SpawnerData((EntityType)CCEntityTypes.GLARE.get(), 20, 1, 1));
        CCBiomeModifierProvider.addSpawn("lost_goat", CCBiomeTags.HAS_LOST_GOAT, new MobSpawnSettings.SpawnerData((EntityType)CCEntityTypes.LOST_GOAT.get(), 1, 1, 1));
        CCBiomeModifierProvider.addFeature("base_ores", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_GOLD_AND_SILVER_LOWER, CCFeatures.CCPlacedFeatures.ORE_SPINEL_BURIED);
        CCBiomeModifierProvider.addFeature("spinel_ore", CCBiomeTags.HAS_SPINEL_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SPINEL);
        CCBiomeModifierProvider.addFeature("silver_ore", CCBiomeTags.HAS_SILVER_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SILVER_BURIED_WITH_GOLD);
        CCBiomeModifierProvider.addFeatureBlacklisted("gold_ore", CCBiomeTags.HAS_SILVER_ORE, (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_GOLD_BURIED_WITH_SILVER);
        CCBiomeModifierProvider.addFeature("extra_silver_ore", CCBiomeTags.HAS_EXTRA_SILVER_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SILVER_EXTRA);
        CCBiomeModifierProvider.addFeature("soul_silver_ore", CCBiomeTags.HAS_SOUL_SILVER_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SILVER_SOUL);
        CCBiomeModifierProvider.addFeature("rocky_dirt", CCBiomeTags.HAS_ROCKY_DIRT, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_ROCKY_DIRT);
        CCBiomeModifierProvider.addFeature("fragile_stone", CCBiomeTags.HAS_FRAGILE_STONE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_FRAGILE_STONE, CCFeatures.CCPlacedFeatures.ORE_FRAGILE_STONE_BURIED);
        CCBiomeModifierProvider.removeFeature("gold_ore", (TagKey<Biome>)BiomeTags.f_215817_, Set.of(GenerationStep.Decoration.UNDERGROUND_ORES), OrePlacements.f_195338_, OrePlacements.f_195339_);
        CCBiomeModifierProvider.removeFeature("dirt_ore", CCBiomeTags.HAS_ROCKY_DIRT, Set.of(GenerationStep.Decoration.UNDERGROUND_ORES), OrePlacements.f_195323_);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"caverns_and_chasms", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)ACCESS), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, MODIFIERS);
    }

    @SafeVarargs
    private static void removeFeature(String name, TagKey<Biome> biomes, Set<GenerationStep.Decoration> steps, Holder<PlacedFeature> ... features) {
        CCBiomeModifierProvider.addModifier("remove_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, biomes), CCBiomeModifierProvider.featureSet(features), steps));
    }

    @SafeVarargs
    private static void addFeature(String name, TagKey<Biome> biomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        CCBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, biomes), CCBiomeModifierProvider.featureSet(features), step));
    }

    @SafeVarargs
    private static void addFeatureBlacklisted(String name, TagKey<Biome> biomes, TagKey<Biome> blacklistedBiomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        CCBiomeModifierProvider.addModifier("add_feature/" + name, new CCBiomeModifierTypes.BlacklistedAddFeaturesBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, biomes), (HolderSet<Biome>)new HolderSet.Named(BIOMES, blacklistedBiomes), CCBiomeModifierProvider.featureSet(features), step));
    }

    private static void addSpawn(String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        CCBiomeModifierProvider.addModifier("add_spawn/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, biomes), List.of(spawns)));
    }

    private static void addSpawnBlacklisted(String name, TagKey<Biome> biomes, TagKey<Biome> blacklistedBiomes, MobSpawnSettings.SpawnerData ... spawns) {
        CCBiomeModifierProvider.addModifier("add_spawn/" + name, new CCBiomeModifierTypes.BlacklistedAddSpawnsBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, biomes), (HolderSet<Biome>)new HolderSet.Named(BIOMES, blacklistedBiomes), List.of(spawns)));
    }

    private static void addModifier(String name, BiomeModifier modifier) {
        MODIFIERS.put(new ResourceLocation("caverns_and_chasms", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(Holder<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_((ResourceKey)registryObject.m_203543_().get())).collect(Collectors.toList()));
    }
}

