/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="caverns_and_chasms", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCBiomeModifierTypes {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"caverns_and_chasms");
    public static final RegistryObject<Codec<BlacklistedAddSpawnsBiomeModifier>> ADD_SPAWNS_BLACKLISTED = BIOME_MODIFIER_SERIALIZERS.register("add_spawns_blacklisted", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("blacklisted_biomes").forGetter(BlacklistedAddSpawnsBiomeModifier::blacklistedBiomes), (App)Biome.f_47432_.fieldOf("biomes").forGetter(BlacklistedAddSpawnsBiomeModifier::biomes), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(BlacklistedAddSpawnsBiomeModifier::spawners)).apply((Applicative)builder, BlacklistedAddSpawnsBiomeModifier::new)));
    public static final RegistryObject<Codec<BlacklistedAddFeaturesBiomeModifier>> ADD_FEATURES_BLACKLISTED = BIOME_MODIFIER_SERIALIZERS.register("add_features_blacklisted", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("blacklisted_biomes").forGetter(BlacklistedAddFeaturesBiomeModifier::blacklistedBiomes), (App)Biome.f_47432_.fieldOf("biomes").forGetter(BlacklistedAddFeaturesBiomeModifier::biomes), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(BlacklistedAddFeaturesBiomeModifier::features), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(BlacklistedAddFeaturesBiomeModifier::step)).apply((Applicative)builder, BlacklistedAddFeaturesBiomeModifier::new)));

    public record BlacklistedAddFeaturesBiomeModifier(HolderSet<Biome> blacklistedBiomes, HolderSet<Biome> biomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && !this.blacklistedBiomes.m_203333_(biome)) {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                this.features.forEach(holder -> generationSettings.m_204201_(this.step, holder));
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)ADD_FEATURES_BLACKLISTED.get();
        }
    }

    public record BlacklistedAddSpawnsBiomeModifier(HolderSet<Biome> blacklistedBiomes, HolderSet<Biome> biomes, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && !this.blacklistedBiomes.m_203333_(biome)) {
                MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
                for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                    EntityType type = spawner.f_48404_;
                    spawns.m_48376_(type.m_20674_(), spawner);
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)ADD_SPAWNS_BLACKLISTED.get();
        }
    }
}

