/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum CriteriaDetail {
    OFF("Off", "Vanilla default", false, false),
    DEFAULT("Default", "List which criteria you have already obtained", true, false),
    SPOILER("Spoiler", "Only reveal unobtained criteria", false, true),
    ALL("All", "Show both obtained and unobtained criteria", true, true);

    private final String name;
    private final String comment;
    private final boolean obtained;
    private final boolean unobtained;

    private CriteriaDetail(String description, String comment, boolean obtained, boolean unobtained) {
        this.name = description;
        this.comment = comment;
        this.obtained = obtained;
        this.unobtained = unobtained;
    }

    public static CriteriaDetail fromName(String value) {
        return Arrays.stream(CriteriaDetail.values()).filter(x -> x.name.equals(value)).findFirst().orElse(DEFAULT);
    }

    public String getName() {
        return this.name;
    }

    public boolean showObtained() {
        return this.obtained;
    }

    public boolean showUnobtained() {
        return this.unobtained;
    }

    public static List<String> names() {
        return Arrays.stream(CriteriaDetail.values()).map(CriteriaDetail::getName).collect(Collectors.toList());
    }

    public static String comments() {
        return "Lists the criteria for partially completed advancements, e.g. the biomes required for 'Adventuring Time'" + Arrays.stream(CriteriaDetail.values()).map(x -> "\n    " + x.getName() + ": " + x.comment).collect(Collectors.joining());
    }

    public static List<CriteriaDetail> valuesAsList() {
        return Arrays.asList(CriteriaDetail.values());
    }
}

