/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.FennecFox;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FennecFoxModel<E extends FennecFox>
extends AgeableListModel<E> {
    public final ModelPart head;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private float legMotion;

    public FennecFoxModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.rightEar = this.head.m_171324_("right_ear");
        this.leftEar = this.head.m_171324_("left_ear");
        this.body = root.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.5f, -1.0f, -5.0f, 7.0f, 5.0f, 5.0f, false).m_171514_(0, 10).m_171506_(-0.5f, 2.0f, -8.0f, 3.0f, 2.0f, 3.0f, false), PartPose.m_171423_((float)-1.0f, (float)16.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171506_(-3.0f, -8.0f, -1.0f, 3.0f, 6.0f, 1.0f, false), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)-1.0f, (float)0.0f, (float)-0.4363f, (float)-0.4363f));
        PartDefinition leftEar = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171506_(0.0f, -8.0f, -1.0f, 3.0f, 6.0f, 1.0f, false), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)-1.0f, (float)0.0f, (float)0.4363f, (float)0.4363f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(12, 10).m_171506_(-2.5f, 2.0f, -3.0f, 5.0f, 6.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-5.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171506_(-3.5f, 0.0f, -1.0f, 3.0f, 8.0f, 3.0f, false), PartPose.m_171423_((float)2.0f, (float)8.0f, (float)-1.0f, (float)-0.0524f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(28, 20).m_171506_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)0.5f, (float)19.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(36, 20).m_171506_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)3.5f, (float)19.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(12, 20).m_171506_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)0.5f, (float)19.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(20, 20).m_171506_(-3.0f, 0.5f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)3.5f, (float)19.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void prepareMobModel(E entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.body.f_104203_ = 1.5707964f;
        this.tail.f_104203_ = -0.05235988f;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.head.m_104227_(-1.0f, 16.0f, -3.0f);
        this.head.f_104204_ = 0.0f;
        this.head.f_104205_ = entityIn.m_28620_(partialTick);
        this.rightHindLeg.f_104207_ = true;
        this.leftHindLeg.f_104207_ = true;
        this.rightFrontLeg.f_104207_ = true;
        this.leftFrontLeg.f_104207_ = true;
        this.body.m_104227_(0.0f, 18.0f, -5.0f);
        this.body.f_104205_ = 0.0f;
        this.rightHindLeg.m_104227_(0.5f, 19.5f, 2.0f);
        this.leftHindLeg.m_104227_(3.5f, 19.5f, 2.0f);
        if (entityIn.m_6047_()) {
            this.body.f_104203_ = 1.6755161f;
            float f = entityIn.m_28624_(partialTick);
            this.body.m_104227_(0.0f, 16.0f + entityIn.m_28624_(partialTick), -5.0f);
            this.head.m_104227_(-1.0f, 15.0f + f, -3.0f);
            this.head.f_104204_ = 0.0f;
        } else if (entityIn.m_5803_()) {
            this.body.f_104205_ = -1.5707964f;
            this.body.m_104227_(-3.0f, 21.0f, -3.0f);
            this.tail.f_104203_ = -1.39626f;
            this.tail.m_104227_(2.0f, 6.0f, -1.0f);
            if (this.f_102610_) {
                this.body.m_104227_(-3.0f, 21.0f, -1.0f);
            }
            this.head.m_104227_(-1.0f, 19.49f, -4.0f);
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = -2.0943952f;
            this.head.f_104205_ = 0.0f;
            this.rightHindLeg.f_104207_ = false;
            this.leftHindLeg.f_104207_ = false;
            this.rightFrontLeg.f_104207_ = false;
            this.leftFrontLeg.f_104207_ = false;
        } else if (entityIn.m_28555_()) {
            this.body.f_104203_ = 0.523599f;
            this.body.m_104227_(0.0f, 15.0f, -2.0f);
            this.tail.f_104203_ = 0.872665f;
            this.tail.m_104227_(2.0f, 8.0f, -1.0f);
            this.head.m_104227_(-1.0f, 14.0f, -1.0f);
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
            if (this.f_102610_) {
                this.head.m_104227_(-1.0f, 14.5f, -1.5f);
            }
            this.rightHindLeg.f_104203_ = -1.5708f;
            this.rightHindLeg.m_104227_(0.5f, 23.0f, 2.0f);
            this.leftHindLeg.f_104203_ = -1.5708f;
            this.leftHindLeg.m_104227_(3.5f, 23.0f, 2.0f);
            this.rightFrontLeg.f_104203_ = -0.436332f;
            this.leftFrontLeg.f_104203_ = -0.436332f;
        }
    }

    public void setupAnim(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entityIn.m_5803_() || entityIn.m_28556_() || entityIn.m_6047_())) {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        }
        if (entityIn.m_5803_()) {
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = -2.0943952f;
            this.head.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.027f)) / 22.0f;
        }
        if (entityIn.m_6047_()) {
            float f;
            this.body.f_104204_ = f = Mth.m_14089_((float)ageInTicks) * 0.01f;
            this.rightHindLeg.f_104205_ = f;
            this.leftHindLeg.f_104205_ = f;
            this.rightFrontLeg.f_104205_ = f / 2.0f;
            this.leftFrontLeg.f_104205_ = f / 2.0f;
        }
        if (entityIn.m_28556_()) {
            this.legMotion += 0.67f;
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(this.legMotion * 0.4662f)) * 0.1f;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(this.legMotion * 0.4662f + (float)Math.PI)) * 0.1f;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(this.legMotion * 0.4662f + (float)Math.PI)) * 0.1f;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(this.legMotion * 0.4662f)) * 0.1f;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }
}

