/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.common.entity.animal.Koi;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KoiModel<T extends Koi>
extends EntityModel<T> {
    public ModelPart front;
    public ModelPart back;
    public ModelPart frontTopFin;
    public ModelPart nose;
    public ModelPart rightWhisker;
    public ModelPart leftWhisker;
    public ModelPart rightFin;
    public ModelPart leftFin;
    public ModelPart tail;
    public ModelPart backTopFin;
    public ModelPart bottomFin;

    public KoiModel(ModelPart root) {
        this.front = root.m_171324_("front");
        this.rightWhisker = this.front.m_171324_("right_whisker");
        this.nose = this.front.m_171324_("nose");
        this.leftFin = this.front.m_171324_("left_fin");
        this.back = this.front.m_171324_("back");
        this.tail = this.back.m_171324_("tail");
        this.bottomFin = this.back.m_171324_("bottom_fin");
        this.backTopFin = this.back.m_171324_("back_top_fin");
        this.rightFin = this.front.m_171324_("right_fin");
        this.frontTopFin = this.front.m_171324_("front_top_fin");
        this.leftWhisker = this.front.m_171324_("left_whisker");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition front = root.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.5f, -2.0f, -8.0f, 3.0f, 4.0f, 8.0f, false), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWhisker = front.m_171599_("left_whisker", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171506_(-3.0f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f, false), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)-8.5f, (float)0.0f, (float)0.7853982f, (float)-0.2617994f));
        PartDefinition nose = front.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-1.5f, -1.0f, -9.0f, 3.0f, 3.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFin = front.m_171599_("left_fin", CubeListBuilder.m_171558_().m_171514_(-6, 12).m_171506_(0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 6.0f, true), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)0.2617994f, (float)0.7853982f));
        PartDefinition back = front.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171506_(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 8.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = back.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171506_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 8.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bottomFin = back.m_171599_("bottom_fin", CubeListBuilder.m_171558_().m_171514_(14, -3).m_171506_(0.0f, 0.0f, -4.0f, 0.0f, 3.0f, 8.0f, false), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition backTopFin = back.m_171599_("back_top_fin", CubeListBuilder.m_171558_().m_171514_(32, -8).m_171506_(0.0f, -3.0f, -4.0f, 0.0f, 3.0f, 8.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFin = front.m_171599_("right_fin", CubeListBuilder.m_171558_().m_171514_(-6, 12).m_171506_(-3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 6.0f, false), PartPose.m_171423_((float)-1.0f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)-0.2617994f, (float)-0.7853982f));
        PartDefinition frontTopFin = front.m_171599_("front_top_fin", CubeListBuilder.m_171558_().m_171514_(14, -8).m_171506_(0.0f, -3.0f, -4.0f, 0.0f, 3.0f, 8.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWhisker = front.m_171599_("right_whisker", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171506_(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f, true), PartPose.m_171423_((float)1.5f, (float)0.0f, (float)-8.5f, (float)0.0f, (float)-0.7853982f, (float)0.2617994f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.front).forEach(modelRenderer -> modelRenderer.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_20069_()) {
            this.setRotateAngle(this.front, this.front.f_104203_, Mth.m_14031_((float)(0.6f * ageInTicks)) * 0.3f * limbSwingAmount, this.front.f_104205_);
            this.setRotateAngle(this.back, this.back.f_104203_, Mth.m_14089_((float)(0.6f * ageInTicks)) * 0.7f * limbSwingAmount, this.back.f_104205_);
            this.setRotateAngle(this.tail, this.tail.f_104203_, Mth.m_14031_((float)(0.6f * ageInTicks)) * 0.75f * limbSwingAmount, this.tail.f_104205_);
        } else {
            this.setRotateAngle(this.front, this.front.f_104203_, -Mth.m_14031_((float)(0.6f * ageInTicks)) * 0.45f, this.front.f_104205_);
            this.setRotateAngle(this.back, this.back.f_104203_, Mth.m_14089_((float)(0.6f * ageInTicks)) * 0.2f, this.back.f_104205_);
            this.setRotateAngle(this.tail, this.tail.f_104203_, -Mth.m_14031_((float)(0.6f * ageInTicks)) * 0.3f, this.tail.f_104205_);
        }
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

