/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import com.teamabnormals.environmental.common.block.DoubleCattailBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class CattailBlock
extends BushBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> Items.f_41868_);

    public CattailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_) || state.m_60713_(Blocks.f_50093_);
    }

    public void placeAt(LevelAccessor worldIn, BlockPos pos, int flags) {
        int type = worldIn.m_213780_().m_188503_(6);
        boolean waterlogged = worldIn.m_46801_(pos);
        if (waterlogged || type > 2) {
            DoubleCattailBlock.placeAt(worldIn, pos, flags, worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_220864_));
        } else if (type > 0) {
            worldIn.m_7731_(pos, (BlockState)((Block)EnvironmentalBlocks.CATTAIL.get()).m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), flags);
        } else {
            worldIn.m_7731_(pos, (BlockState)((Block)EnvironmentalBlocks.CATTAIL_SPROUTS.get()).m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), flags);
        }
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem(this.m_5456_(), group, items);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.m_60824_(worldIn, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        DoubleCattailBlock doubleplantblock = (DoubleCattailBlock)((Object)EnvironmentalBlocks.TALL_CATTAIL.get());
        FluidState ifluidstateUp = worldIn.m_6425_(pos.m_7494_());
        if (doubleplantblock.m_49966_().m_60710_((LevelReader)worldIn, pos) && (worldIn.m_46859_(pos.m_7494_()) || ifluidstateUp.m_205070_(FluidTags.f_13131_) && ifluidstateUp.m_76186_() == 8)) {
            DoubleCattailBlock.placeAt((LevelAccessor)worldIn, pos, 2);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        DoubleCattailBlock tallCattail;
        super.m_213897_(state, worldIn, pos, random);
        if (worldIn.m_45524_(pos.m_7494_(), 0) >= 9 && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(15) == 0 ? 1 : 0) != 0) && (tallCattail = (DoubleCattailBlock)((Object)EnvironmentalBlocks.TALL_CATTAIL.get())).m_49966_().m_60710_((LevelReader)worldIn, pos) && worldIn.m_46859_(pos.m_7494_())) {
            DoubleCattailBlock.placeAt((LevelAccessor)worldIn, pos, 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.m_6266_(world.m_8055_(pos.m_7495_()), (BlockGetter)world, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }
}

