/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class DoubleCattailBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty FAKE_WATERLOGGED = BooleanProperty.m_61465_((String)"fake_waterlogged");
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_TOP = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> Items.f_42211_);

    public DoubleCattailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.m_60824_(worldIn, pos);
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? SHAPE_TOP.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_) : SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HALF, WATERLOGGED, FAKE_WATERLOGGED});
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_) || state.m_60713_(Blocks.f_50093_);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return this.isValidGround(worldIn.m_8055_(pos.m_7495_()), (BlockGetter)worldIn, pos);
        }
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            this.isValidGround(worldIn.m_8055_(pos.m_7495_()), (BlockGetter)worldIn, pos);
        }
        return blockstate.m_60734_() == this && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos = context.m_8083_();
        return context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context) ? (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8))).m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8)) : null;
    }

    public static void placeAt(LevelAccessor level, BlockPos pos, int flags) {
        DoubleCattailBlock.placeAt(level, pos, flags, false);
    }

    public static void placeAt(LevelAccessor worldIn, BlockPos pos, int flags, boolean seeds) {
        FluidState ifluidstate = worldIn.m_6425_(pos);
        FluidState ifluidstateUp = worldIn.m_6425_(pos.m_7494_());
        boolean applyFakeWaterLogging = ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8 || ifluidstateUp.m_205070_(FluidTags.f_13131_) && ifluidstateUp.m_76186_() == 8;
        worldIn.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.TALL_CATTAIL.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(seeds ? 1 : 0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8))).m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(applyFakeWaterLogging)), flags);
        worldIn.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.TALL_CATTAIL.get()).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(seeds ? 1 : 0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstateUp.m_205070_(FluidTags.f_13131_) && ifluidstateUp.m_76186_() == 8))).m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(applyFakeWaterLogging)), flags);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean flag;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = i == 1;
        if (!flag && player.m_21120_(handIn).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (i > 0) {
            RandomSource rand = RandomSource.m_216327_();
            int j = 1 + rand.m_188503_(3);
            DoubleCattailBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)EnvironmentalBlocks.CATTAIL_SPROUTS.get(), j));
            worldIn.m_5594_(null, pos, (SoundEvent)EnvironmentalSoundEvents.CATTAIL_PICK_SEEDS.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                worldIn.m_7731_(pos.m_7495_(), (BlockState)worldIn.m_8055_(pos.m_7495_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            } else {
                worldIn.m_7731_(pos.m_7494_(), (BlockState)worldIn.m_8055_(pos.m_7494_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem(this.m_5456_(), group, items);
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 1) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                worldIn.m_46597_(pos.m_7495_(), (BlockState)worldIn.m_8055_(pos.m_7495_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
            } else {
                worldIn.m_46597_(pos.m_7494_(), (BlockState)worldIn.m_8055_(pos.m_7494_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.m_213897_(state, worldIn, pos, random);
        int i = (Integer)state.m_61143_((Property)AGE);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && i < 1 && worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_220864_) && worldIn.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(15) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            if (worldIn.m_8055_(pos.m_7494_()).m_60734_() == this && (Integer)worldIn.m_8055_(pos.m_7494_()).m_61143_((Property)AGE) == 0) {
                worldIn.m_7731_(pos.m_7494_(), (BlockState)worldIn.m_8055_(pos.m_7494_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            if (doubleblockhalf == DoubleBlockHalf.UPPER && !((Boolean)stateIn.m_61143_((Property)FAKE_WATERLOGGED)).booleanValue()) {
                stateIn = (BlockState)stateIn.m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true));
                worldIn.m_7731_(currentPos, (BlockState)worldIn.m_8055_(currentPos).m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            } else if (doubleblockhalf == DoubleBlockHalf.LOWER && !((Boolean)stateIn.m_61143_((Property)FAKE_WATERLOGGED)).booleanValue()) {
                stateIn = (BlockState)stateIn.m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true));
                worldIn.m_7731_(currentPos, (BlockState)worldIn.m_8055_(currentPos).m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        if (facing.m_122434_() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.m_60734_() == this && facingState.m_61143_(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            if (player.m_7500_()) {
                DoubleCattailBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                DoubleCattailBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            BlockPos blockpos2 = pos.m_7495_();
            BlockState blockstate2 = world.m_8055_(blockpos2);
            if (blockstate2.m_60734_() == state.m_60734_() && blockstate2.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                world.m_7731_(blockpos2, world.m_6425_(blockpos2).m_76186_() == 8 ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 51);
                world.m_5898_(player, 2001, blockpos2, Block.m_49956_((BlockState)blockstate2));
            }
        } else if (doubleblockhalf == DoubleBlockHalf.LOWER && (blockstate = world.m_8055_(blockpos = pos.m_7494_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            world.m_7731_(blockpos, world.m_6425_(blockpos).m_76186_() == 8 ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 51);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        FluidState ifluidstateUp = worldIn.m_6425_(pos.m_7494_());
        worldIn.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstateUp.m_205070_(FluidTags.f_13131_) && ifluidstateUp.m_76186_() == 8))).m_61124_((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_) && worldIn.m_6425_(pos).m_76186_() == 8)), 3);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        boolean upper;
        boolean bl = upper = state.m_61143_(HALF) == DoubleBlockHalf.UPPER;
        return (Integer)state.m_61143_((Property)AGE) < 1 && (upper ? worldIn.m_8055_(pos.m_7495_().m_7495_()).m_60713_(Blocks.f_220864_) : worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_220864_));
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        boolean upper;
        boolean bl = upper = state.m_61143_(HALF) == DoubleBlockHalf.UPPER;
        return (Integer)state.m_61143_((Property)AGE) < 1 && (upper ? worldIn.m_8055_(pos.m_7495_().m_7495_()).m_60713_(Blocks.f_220864_) : worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_220864_));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }
}

