/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;

public class WisteriaLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IForgeShearable {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)8);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> Items.f_41901_);

    public WisteriaLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(8))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 8 && (Boolean)state.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue() && (Integer)state.m_61143_((Property)DISTANCE) == 8) {
            WisteriaLeavesBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            level.m_7471_(pos, false);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, WisteriaLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        int i;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((i = WisteriaLeavesBlock.getDistanceAt(facingState) + 1) != 1 || (Integer)state.m_61143_((Property)DISTANCE) != i) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    public static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 8;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutablePos.m_122159_((Vec3i)pos, direction);
            i = Math.min(i, WisteriaLeavesBlock.getDistanceAt(level.m_8055_((BlockPos)mutablePos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) ? 0 : (state.m_60734_() instanceof WisteriaLeavesBlock ? (Integer)state.m_61143_((Property)DISTANCE) : (state.m_60734_() instanceof LeavesBlock ? (Integer)state.m_61143_((Property)LeavesBlock.f_54418_) : 8));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos belowPos;
        BlockState belowState;
        if (!(!level.m_46758_(pos.m_7494_()) || random.m_188503_(15) != 1 || (belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60815_() && belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP))) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_192917_((Fluid)Fluids.f_76193_)));
        return WisteriaLeavesBlock.updateDistance(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem(this.m_5456_(), group, items);
    }
}

