/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Koi
extends AbstractFish {
    public Koi(EntityType<? extends AbstractFish> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
        this.m_21441_(BlockPathTypes.WATER, 0.4f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 4.25));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 50));
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vector3d = this.m_20184_();
        if ((double)Mth.m_14154_((float)((float)vector3d.f_82480_)) >= 0.01) {
            this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)Mth.m_14116_((float)((float)vector3d.m_165925_()))) * 57.2957763671875));
        } else {
            this.m_146926_(0.0f);
        }
        this.m_146926_(Koi.normalizeRotation(this.f_19860_, this.m_146909_()));
    }

    protected static float normalizeRotation(float prevRot, float rot) {
        while (rot - prevRot < -180.0f) {
            prevRot -= 360.0f;
        }
        while (rot - prevRot >= 180.0f) {
            prevRot += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)prevRot, (float)rot);
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.45f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(this.m_5699_(), this.m_6121_(), this.m_6100_());
        }
        if (this.f_19853_.m_46467_() % 20L == 0L && ((Boolean)EnvironmentalConfig.COMMON.serenityEffect.get()).booleanValue()) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (Player player : this.f_19853_.m_45976_(Player.class, this.m_20191_().m_82377_((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (this.f_19853_.m_5776_()) continue;
                player.m_7292_(new MobEffectInstance((MobEffect)EnvironmentalMobEffects.SERENITY.get(), 100, 0, false, false));
            }
        }
        super.m_8107_();
    }

    public SoundEvent m_5699_() {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_FLOP.get();
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11761_;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)EnvironmentalItems.KOI_BUCKET.get());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    public static boolean canKoiSpawn(EntityType<? extends AbstractFish> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.m_8055_(pos).m_60713_(Blocks.f_49990_) && worldIn.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && pos.m_123342_() > 55;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Koi koi;

        public MoveHelperController(Koi koi) {
            super((Mob)koi);
            this.koi = koi;
        }

        public void m_8126_() {
            if (this.koi.m_204029_(FluidTags.f_13131_)) {
                this.koi.m_20256_(this.koi.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.koi.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.koi.m_20185_();
                double d1 = this.f_24976_ - this.koi.m_20186_();
                double d2 = this.f_24977_ - this.koi.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                if (d0 != 0.0 || (d1 /= d3) != 0.0) {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.koi.m_146922_(this.m_24991_(this.koi.m_146908_(), f, 15.0f));
                    this.koi.f_20883_ = this.koi.m_146908_();
                    this.koi.f_20885_ = this.koi.m_146908_();
                }
                float f1 = (float)(this.f_24978_ * this.koi.m_21051_(Attributes.f_22279_).m_22135_());
                this.koi.m_7910_(Mth.m_14179_((float)0.125f, (float)this.koi.m_6113_(), (float)f1));
                this.koi.m_20256_(this.koi.m_20184_().m_82520_(0.0, (double)this.koi.m_6113_() * d1 * 0.03, 0.0));
            }
        }
    }
}

