/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractDeer
extends Animal {
    private static final EntityDataAccessor<Integer> TARGET_NECK_ANGLE = SynchedEntityData.m_135353_(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_ANTLERS = SynchedEntityData.m_135353_(AbstractDeer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions GRAZING_DIMENSIONS = EntityDimensions.m_20395_((float)0.8f, (float)1.2f);
    private static final Predicate<LivingEntity> AVOID_ENTITY_PREDICATE = entity -> entity.m_6095_().m_204039_(EnvironmentalEntityTypeTags.SCARES_DEER) && !entity.m_20163_() && EntitySelector.f_20406_.test(entity);
    private static final Predicate<LivingEntity> TRUSTING_AVOID_ENTITY_PREDICATE = entity -> {
        if (!entity.m_6095_().m_204039_(EnvironmentalEntityTypeTags.SCARES_TRUSTING_DEER) || entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_()) {
            return false;
        }
        return !entity.m_20163_() && EntitySelector.f_20406_.test(entity);
    };
    private static final TargetingConditions AVOID_ENTITY_TARGETING = TargetingConditions.m_148352_().m_26883_(10.0).m_26888_(AVOID_ENTITY_PREDICATE);
    private static final TargetingConditions TRUSTING_AVOID_ENTITY_TARGETING = TargetingConditions.m_148352_().m_26883_(10.0).m_26888_(TRUSTING_AVOID_ENTITY_PREDICATE);
    private float neckAngle = 15.0f;
    private float neckAngleO = 15.0f;
    private float sprintAmount;
    private float sprintAmountO;
    private int hopProgress;
    private float hopAmount;
    private float hopAmountO;
    private float hopAngle;
    private float hopAngleO;

    public AbstractDeer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_NECK_ANGLE, (Object)15);
        this.f_19804_.m_135372_(HAS_ANTLERS, (Object)true);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Antlers", this.hasAntlers());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasAntlers(compound.m_128471_("Antlers"));
    }

    public void m_8024_() {
        this.m_6858_(!this.m_20069_() && this.m_21566_().m_24995_() && this.m_21566_().m_24999_() >= 1.75);
        super.m_8024_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateNeckAngle();
        this.updateSprintAnimation();
        this.updateHopAnimation();
    }

    private void updateNeckAngle() {
        this.neckAngleO = this.neckAngle;
        int i = this.getTargetNeckAngle();
        float f = this.neckAngle + ((float)i - this.neckAngle) * 0.3f;
        this.neckAngle = this.neckAngle < (float)i == f > (float)i ? (float)i : f;
    }

    private void updateSprintAnimation() {
        this.sprintAmountO = this.sprintAmount;
        this.sprintAmount = this.m_20142_() ? Math.min(1.0f, this.sprintAmount + 0.1f) : Math.max(0.0f, this.sprintAmount - 0.1f);
    }

    private void updateHopAnimation() {
        this.hopAmountO = this.hopAmount;
        this.hopAngleO = this.hopAngle;
        if (this.hopProgress != 3) {
            --this.hopProgress;
        } else if (this.m_20096_() || this.m_20072_()) {
            this.hopProgress = 2;
        }
        if (this.hopProgress >= 3) {
            this.hopAngle = this.hopProgress > 3 ? Math.max(-0.2f, this.hopAngle - 0.18f) : Math.min(0.2f, this.hopAngle + 0.08f);
            this.hopAmount = Math.min(1.0f, this.hopAmount + 0.25f);
        } else if (this.hopAngle > 0.0f) {
            this.hopAngle = Math.max(0.0f, this.hopAngle - 0.05f);
        } else if (this.hopAngle < 0.0f) {
            this.hopAngle = Math.min(0.0f, this.hopAngle + 0.05f);
        }
        this.hopAmount = this.hopProgress > 0 ? Math.min(1.0f, this.hopAmount + 0.25f) : Math.max(0.0f, this.hopAmount - 0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.isGrazing() ? dimensions.f_20378_ * 0.3f : dimensions.f_20378_ * 0.95f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isGrazing()) {
            return GRAZING_DIMENSIONS.m_20388_(this.m_6134_());
        }
        return super.m_6972_(pose);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.DEER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.DEER_STEP.get(), 0.15f, 1.0f);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (TARGET_NECK_ANGLE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.hopProgress = 10;
        } else {
            super.m_7822_(id);
        }
    }

    private int getTargetNeckAngle() {
        return (Integer)this.f_19804_.m_135370_(TARGET_NECK_ANGLE);
    }

    public void setTargetNeckAngle(int angle) {
        this.f_19804_.m_135381_(TARGET_NECK_ANGLE, (Object)angle);
    }

    public void resetTargetNeckAngle() {
        this.setTargetNeckAngle(15);
    }

    public float getNeckAngle(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.neckAngleO, (float)this.neckAngle);
    }

    private boolean isGrazing() {
        return this.getTargetNeckAngle() >= 90;
    }

    public float getSprintAmount(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.sprintAmountO, (float)this.sprintAmount);
    }

    public float getHopAmount(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.hopAmountO, (float)this.hopAmount);
    }

    public float getHopAngle(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.hopAngleO, (float)this.hopAngle);
    }

    public void setHasAntlers(boolean antlers) {
        this.f_19804_.m_135381_(HAS_ANTLERS, (Object)antlers);
    }

    public boolean hasAntlers() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ANTLERS);
    }

    public boolean isTrusting() {
        return false;
    }

    public LivingEntity getNearestScaryEntity() {
        return this.f_19853_.m_45982_(this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_(10.0, 4.0, 10.0), p_148124_ -> true), this.isTrusting() ? TRUSTING_AVOID_ENTITY_TARGETING : AVOID_ENTITY_TARGETING, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setHasAntlers(this.f_19796_.m_188499_());
        return super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }
}

