/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.common.entity.ai.goal.DeerAvoidEntityGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.DeerFollowParentGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.DeerFrolicGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.DeerGrazeGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.DeerRunFromAttackerGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.DeerTemptGoal;
import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import com.teamabnormals.environmental.common.entity.animal.deer.DeerCoatColors;
import com.teamabnormals.environmental.common.entity.animal.deer.DeerCoatTypes;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class Deer
extends AbstractDeer {
    private static final EntityDataAccessor<Integer> DEER_COAT_COLOR = SynchedEntityData.m_135353_(Deer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DEER_COAT_TYPE = SynchedEntityData.m_135353_(Deer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLOWER_AMOUNT = SynchedEntityData.m_135353_(Deer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TRUSTING = SynchedEntityData.m_135353_(Deer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int floweringTime = 0;
    private final List<BlockState> flowers = new ArrayList<BlockState>();
    @Nullable
    private TemptGoal temptGoal;

    public Deer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.temptGoal = new DeerTemptGoal(this, 0.6, 1.1, Ingredient.m_204132_(EnvironmentalItemTags.DEER_TEMPT_ITEMS));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DeerFollowParentGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DeerRunFromAttackerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DeerAvoidEntityGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new DeerFrolicGoal(this));
        this.f_21345_.m_25352_(6, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(7, (Goal)new DeerGrazeGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEER_COAT_COLOR, (Object)0);
        this.f_19804_.m_135372_(DEER_COAT_TYPE, (Object)0);
        this.f_19804_.m_135372_(FLOWER_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(TRUSTING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CoatColor", this.getCoatColor());
        compound.m_128405_("CoatType", this.getCoatType());
        compound.m_128379_("Trusting", this.isTrusting());
        compound.m_128405_("FloweringTime", this.floweringTime);
        compound.m_128405_("FlowerAmount", this.getFlowerAmount());
        ListTag listtag = new ListTag();
        for (BlockState blockstate : this.flowers) {
            if (blockstate == null) continue;
            listtag.add((Object)NbtUtils.m_129202_((BlockState)blockstate));
        }
        compound.m_128365_("Flowers", (Tag)listtag);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCoatColor(compound.m_128451_("CoatColor"));
        this.setCoatType(compound.m_128451_("CoatType"));
        this.setTrusting(compound.m_128471_("Trusting"));
        this.floweringTime = compound.m_128451_("FloweringTime");
        this.setFlowerAmount(compound.m_128451_("FlowerAmount"));
        ListTag listtag = compound.m_128437_("Flowers", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            BlockState blockstate = NbtUtils.m_129241_((CompoundTag)listtag.m_128728_(i));
            if (blockstate == null || blockstate.m_60795_()) continue;
            this.flowers.add(blockstate);
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            if (this.getFlowerAmount() > 0 && this.f_19797_ % 16 == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.floweringTime > 0) {
                --this.floweringTime;
            }
            if (this.floweringTime <= 0 && this.getFlowerAmount() > 0 || this.getFlowerAmount() <= 0 && !this.flowers.isEmpty()) {
                this.setFlowerAmount(0);
                this.flowers.clear();
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean flag;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        boolean bl = flag = player.m_7500_() || this.temptGoal == null || this.temptGoal.m_25955_();
        if (!this.m_6162_() && (this.isTrusting() || flag)) {
            if (stack.m_150930_(Items.f_42575_)) {
                this.setFlowerAmount(this.getFlowerAmount() + 6);
                this.floweringTime += 2400;
                this.particleCloud((ParticleOptions)ParticleTypes.f_123748_);
                this.m_142075_(player, hand, stack);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_150930_(Items.f_42546_)) {
                this.setFlowerAmount(this.getFlowerAmount() + 20);
                this.floweringTime += 2400;
                this.particleCloud((ParticleOptions)ParticleTypes.f_123748_);
                this.m_142075_(player, hand, stack);
                return InteractionResult.SUCCESS;
            }
            if (this.getFlowerAmount() > 0 && stack.m_204117_(EnvironmentalItemTags.DEER_PLANTABLES) && item instanceof BlockItem) {
                BlockItem block = (BlockItem)item;
                if (!this.flowers.contains(block.m_40614_().m_49966_())) {
                    this.flowers.add(block.m_40614_().m_49966_());
                    this.floweringTime = Math.max(600, this.floweringTime);
                    this.particleCloud((ParticleOptions)ParticleTypes.f_123748_);
                    this.m_142075_(player, hand, stack);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
        }
        if (!this.isTrusting()) {
            if (flag && this.m_6898_(stack)) {
                if (!this.f_19853_.f_46443_) {
                    this.m_142075_(player, hand, stack);
                    if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.setTrusting(true);
                        this.spawnTrustingParticles(true);
                        this.f_19853_.m_7605_((Entity)this, (byte)5);
                    } else {
                        this.spawnTrustingParticles(false);
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public void spawnFlower() {
        if (this.isSpreadingFlowers()) {
            BlockPos pos = this.m_20183_();
            BlockState state = this.flowers.get(this.f_19796_.m_188503_(this.flowers.size()));
            boolean tall = state.m_60734_() instanceof DoublePlantBlock;
            if (state.m_60710_((LevelReader)this.f_19853_, pos) && this.f_19853_.m_46859_(pos) && (!tall || this.f_19853_.m_46859_(pos.m_7494_()))) {
                if (!tall) {
                    this.f_19853_.m_7731_(pos, state, 3);
                } else {
                    DoublePlantBlock.m_153173_((LevelAccessor)this.f_19853_, (BlockState)state, (BlockPos)pos, (int)2);
                }
                SoundType sound = state.m_60827_();
                this.m_5496_(sound.m_56777_(), (sound.m_56773_() + 1.0f) / 4.0f, sound.m_56774_() * 0.8f);
                this.setFlowerAmount(this.getFlowerAmount() - 1);
                this.spawnBoneMealParticles(state, pos);
            }
        }
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 5) {
            this.spawnTrustingParticles(true);
        } else if (id == 6) {
            this.spawnTrustingParticles(false);
        } else {
            super.m_7822_(id);
        }
    }

    private void particleCloud(ParticleOptions particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_(particle, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private void spawnTrustingParticles(boolean trusts) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!trusts) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private void spawnBoneMealParticles(BlockState blockstate, BlockPos blockpos) {
        double d1;
        int amount = 15;
        double d0 = 0.5;
        if (blockstate.m_60804_((BlockGetter)this.f_19853_, blockpos)) {
            blockpos = blockpos.m_7494_();
            amount *= 3;
            d0 = 3.0;
            d1 = 1.0;
        } else {
            d1 = blockstate.m_60808_((BlockGetter)this.f_19853_, blockpos).m_83297_(Direction.Axis.Y);
        }
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        RandomSource random = this.f_19853_.m_213780_();
        for (int i = 0; i < amount; ++i) {
            double d2 = random.m_188583_() * 0.02;
            double d3 = random.m_188583_() * 0.02;
            double d4 = random.m_188583_() * 0.02;
            double d5 = 0.5 - d0;
            double d6 = (double)blockpos.m_123341_() + d5 + random.m_188500_() * d0 * 2.0;
            double d7 = (double)blockpos.m_123342_() + random.m_188500_() * d1;
            double d8 = (double)blockpos.m_123343_() + d5 + random.m_188500_() * d0 * 2.0;
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, d6, d7, d8, 0, d2, d3, d4, 0.0);
        }
    }

    private void setCoatColor(int id) {
        this.f_19804_.m_135381_(DEER_COAT_COLOR, (Object)id);
    }

    public int getCoatColor() {
        return (Integer)this.f_19804_.m_135370_(DEER_COAT_COLOR);
    }

    private void setCoatType(int id) {
        int color = this.getCoatColor();
        if (color == 2 && id == 1) {
            this.f_19804_.m_135381_(DEER_COAT_TYPE, (Object)0);
        } else {
            this.f_19804_.m_135381_(DEER_COAT_TYPE, (Object)id);
        }
    }

    public int getCoatType() {
        return (Integer)this.f_19804_.m_135370_(DEER_COAT_TYPE);
    }

    public boolean isSpreadingFlowers() {
        return this.getFlowerAmount() > 0 && !this.flowers.isEmpty();
    }

    private int getFlowerAmount() {
        return (Integer)this.f_19804_.m_135370_(FLOWER_AMOUNT);
    }

    private void setFlowerAmount(int amount) {
        this.f_19804_.m_135381_(FLOWER_AMOUNT, (Object)amount);
    }

    private void setTrusting(boolean trusting) {
        this.f_19804_.m_135381_(TRUSTING, (Object)trusting);
    }

    @Override
    public boolean isTrusting() {
        return (Boolean)this.f_19804_.m_135370_(TRUSTING);
    }

    private void setHoliday() {
        this.setCoatColor(DeerCoatColors.HOLIDAY.getId());
        this.setHasAntlers(true);
    }

    public boolean isHoliday() {
        return this.getCoatColor() == DeerCoatColors.HOLIDAY.getId();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(EnvironmentalItemTags.DEER_FOOD);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageable) {
        Deer entity = (Deer)((EntityType)EnvironmentalEntityTypes.DEER.get()).m_20615_((Level)level);
        Deer partner = (Deer)ageable;
        if (entity != null) {
            entity.setCoatColor(this.f_19796_.m_188499_() ? partner.getCoatColor() : this.getCoatColor());
            entity.setCoatType(this.f_19796_.m_188499_() ? partner.getCoatType() : this.getCoatType());
            entity.setHasAntlers(this.f_19796_.m_188499_());
            entity.setTrusting(this.isTrusting() || partner.isTrusting());
            if (this.isHolidayCriteria()) {
                entity.setHoliday();
            }
        }
        return entity;
    }

    private boolean isHolidayCriteria() {
        if (this.f_19796_.m_188503_(9) == 0) {
            LocalDate localdate = LocalDate.now();
            int month = localdate.get(ChronoField.MONTH_OF_YEAR);
            return month == 12 && ((Biome)this.f_19853_.m_204166_(this.m_20183_()).m_203334_()).m_47530_() == Biome.Precipitation.SNOW;
        }
        return false;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int deerCoatColor;
        if (spawnDataIn instanceof DeerSpawnGroupData) {
            DeerSpawnGroupData deerSpawnGroupData = (DeerSpawnGroupData)spawnDataIn;
            deerCoatColor = deerSpawnGroupData.coatColor;
        } else {
            deerCoatColor = this.f_19796_.m_188503_(DeerCoatColors.values().length - 1);
            spawnDataIn = new DeerSpawnGroupData(deerCoatColor);
        }
        this.setCoatColor(deerCoatColor);
        this.setCoatType(this.f_19796_.m_188503_(DeerCoatTypes.values().length));
        if (this.isHolidayCriteria()) {
            this.setHoliday();
        }
        return super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }

    public static class DeerSpawnGroupData
    extends AgeableMob.AgeableMobGroupData
    implements SpawnGroupData {
        public final int coatColor;

        public DeerSpawnGroupData(int coatColor) {
            super(0.3f);
            this.coatColor = coatColor;
        }
    }
}

