/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item.explorer;

import com.teamabnormals.environmental.client.model.HealerPouchModel;
import com.teamabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class HealerPouchItem
extends ExplorerArmorItem {
    private static final String NBT_TAG = "HealerPouchUses";

    public HealerPouchItem(Item.Properties properties) {
        super(EquipmentSlot.CHEST, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> properties) {
                return HealerPouchModel.INSTANCE;
            }
        });
    }

    @SubscribeEvent
    public static void onEvent(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = entity.m_6844_(EquipmentSlot.CHEST);
        if (stack.m_41720_() instanceof HealerPouchItem && event.getSource().m_7639_() instanceof LivingEntity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_36335_().m_41519_(stack.m_41720_())) {
                    CompoundTag tag = stack.m_41784_();
                    int increase = ((HealerPouchItem)stack.m_41720_()).getIncreaseForUses(tag.m_128451_(NBT_TAG));
                    int panicSeconds = 4 * increase;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20 * panicSeconds, increase > 2 ? 1 : 0));
                    player.m_7292_(new MobEffectInstance((MobEffect)EnvironmentalMobEffects.PANIC.get(), 20 * panicSeconds, 0));
                    player.m_36335_().m_41524_(stack.m_41720_(), 20 * (panicSeconds + (10 - increase * 2)));
                    ((HealerPouchItem)stack.m_41720_()).levelUp(stack, (LivingEntity)player);
                }
            } else if (entity.f_19853_.m_213780_().m_188503_(entity.f_19853_.m_46791_().m_19028_() + 3) != 0) {
                entity.m_5634_(4.0f);
                entity.m_7292_(new MobEffectInstance((MobEffect)EnvironmentalMobEffects.PANIC.get(), 120, 0));
            }
        }
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 10, 50, 100, 250};
    }
}

