/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import com.teamabnormals.environmental.common.block.HangingWisteriaLeavesBlock;
import com.teamabnormals.environmental.common.levelgen.feature.WisteriaTreeFeature;
import com.teamabnormals.environmental.common.levelgen.util.WisteriaTreeUtil;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class BigWisteriaTreeFeature
extends Feature<TreeConfiguration> {
    public BigWisteriaTreeFeature(Codec<TreeConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        BlockState vine = WisteriaTreeFeature.getHangingWisteriaLeavesState(random, pos, config);
        HashSet logPosSet = Sets.newHashSet();
        int height = random.m_188503_(7) + 5;
        boolean flag = true;
        if (pos.m_123342_() >= 1 && pos.m_123342_() + height + 1 <= world.m_151558_()) {
            for (int j = pos.m_123342_(); j <= pos.m_123342_() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.m_123342_()) {
                    k = 0;
                }
                if (j >= pos.m_123342_() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.m_123341_() - k; l <= pos.m_123341_() + k && flag; ++l) {
                    for (int i1 = pos.m_123343_() - k; i1 <= pos.m_123343_() + k && flag; ++i1) {
                        if (j >= 0 && j < world.m_151558_()) {
                            if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtil.isValidGround((LevelAccessor)world, (BlockPos)pos.m_7495_(), (SaplingBlock)((SaplingBlock)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get())) && pos.m_123342_() < world.m_151558_() - height - 1) {
                TreeUtil.setDirtAt((LevelAccessor)world, (BlockPos)pos.m_7495_());
                for (int k = 0; k < 3; ++k) {
                    BlockPos position = new BlockPos((Vec3i)pos.m_7918_(0, random.m_188503_(3) + 4, 0));
                    boolean xNeg = random.m_188499_();
                    boolean zNeg = random.m_188499_();
                    int size = random.m_188503_(3) + 5;
                    for (int j = 1; j <= size; ++j) {
                        position = position.m_7918_(random.m_188503_(2) - (xNeg ? 1 : 0), random.m_188503_(2), random.m_188503_(2) - (zNeg ? 1 : 0));
                        TreeUtil.placeLogAt((LevelWriter)world, (BlockPos)position, (RandomSource)random, (TreeConfiguration)config);
                        logPosSet.add(position.m_7949_());
                        if (j != size) continue;
                        for (int y = 4; y > -4; --y) {
                            for (int x = 4; x > -4; --x) {
                                for (int z = 4; z > -4; --z) {
                                    int n = y > 0 ? y * y : 0;
                                    if (!(Math.sqrt(x * x + n + z * z) <= 4.0)) continue;
                                    BlockPos leafPos = position.m_7918_(x, y, z);
                                    boolean place = true;
                                    if (y < 0 && (place = TreeUtil.isLeaves((LevelSimulatedReader)world, (BlockPos)leafPos.m_7918_(0, 1, 0))) && random.m_188503_(Math.abs(y) + 1) != 0) {
                                        place = false;
                                        if (random.m_188503_(5) == 0 && !TreeUtil.isLog((LevelSimulatedReader)world, (BlockPos)leafPos)) {
                                            WisteriaTreeUtil.placeVines((LevelSimulatedRW)world, random, leafPos, config.f_161213_.m_213972_(random, pos));
                                        }
                                    }
                                    if (!place) continue;
                                    WisteriaTreeUtil.placeLeafAt((LevelSimulatedRW)world, leafPos, config.f_161213_.m_213972_(random, pos));
                                }
                            }
                        }
                    }
                }
                for (int i2 = 0; i2 < height; ++i2) {
                    if (!WisteriaTreeUtil.isAirOrLeavesOrReplaceable((LevelSimulatedReader)world, pos.m_6630_(i2))) continue;
                    TreeUtil.placeLogAt((LevelWriter)world, (BlockPos)pos.m_6630_(i2), (RandomSource)random, (TreeConfiguration)config);
                    logPosSet.add(pos.m_6630_(i2).m_7949_());
                }
                BlockPos startPos = pos.m_6630_(height);
                for (BlockPos blockpos : BlockPos.m_121976_((int)(startPos.m_123341_() - 10), (int)(startPos.m_123342_() - 10), (int)(startPos.m_123343_() - 10), (int)(startPos.m_123341_() + 10), (int)(startPos.m_123342_() + 10), (int)(startPos.m_123343_() + 10))) {
                    if (!world.m_8055_(blockpos).m_60795_() || !BigWisteriaTreeFeature.isLeaves((LevelSimulatedReader)world, blockpos.m_7494_(), config, random) || random.m_188503_(4) != 0) continue;
                    TreeUtil.setForcedState((LevelWriter)world, (BlockPos)blockpos, (BlockState)((BlockState)vine.m_61124_(HangingWisteriaLeavesBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)));
                    if (!world.m_8055_(blockpos.m_7495_()).m_60795_() || random.m_188503_(2) != 0) continue;
                    TreeUtil.setForcedState((LevelWriter)world, (BlockPos)blockpos.m_7495_(), (BlockState)((BlockState)vine.m_61124_(HangingWisteriaLeavesBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)));
                }
                WisteriaTreeUtil.updateLeaves((LevelAccessor)world, logPosSet);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isLeaves(LevelSimulatedReader worldIn, BlockPos pos, TreeConfiguration config, RandomSource random) {
        if (worldIn instanceof LevelReader) {
            return worldIn.m_7433_(pos, state -> state == config.f_161213_.m_213972_(random, pos));
        }
        return worldIn.m_7433_(pos, p_227223_0_ -> config.f_161213_.m_213972_(random, pos) == p_227223_0_);
    }
}

