/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class CherryTreeFeature
extends Feature<TreeConfiguration> {
    private Set<BlockPos> logPosSet;

    public CherryTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        int height = 5 + random.m_188503_(3) + random.m_188503_(2) + random.m_188503_(2);
        boolean flag = true;
        this.logPosSet = Sets.newHashSet();
        if (pos.m_123342_() >= level.m_141937_() && pos.m_123342_() + height + 1 <= level.m_151558_()) {
            for (int j = pos.m_123342_(); j <= pos.m_123342_() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.m_123342_()) {
                    k = 0;
                }
                if (j >= pos.m_123342_() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int l = pos.m_123341_() - k; l <= pos.m_123341_() + k && flag; ++l) {
                    for (int i1 = pos.m_123343_() - k; i1 <= pos.m_123343_() + k && flag; ++i1) {
                        if (j >= 0 && j < level.m_151558_()) {
                            if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)mutablePos.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (CherryTreeFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos.m_7495_()) && pos.m_123342_() < level.m_151558_()) {
                TreeUtil.setDirtAt((LevelAccessor)level, (BlockPos)pos.m_7495_());
                int logX = pos.m_123341_();
                int logZ = pos.m_123343_();
                for (int k = 0; k < height; ++k) {
                    int logY = pos.m_123342_() + k;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (!TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)blockpos)) continue;
                    TreeUtil.placeLogAt((LevelWriter)level, (BlockPos)blockpos, (RandomSource)random, (TreeConfiguration)config);
                    this.logPosSet.add(blockpos.m_7494_().m_7949_());
                }
                Direction.Plane.HORIZONTAL.m_122557_().forEach(direction -> {
                    BlockPos stumpPos = pos.m_121945_(direction);
                    if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)stumpPos) && CherryTreeFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)stumpPos.m_7495_())) {
                        TreeUtil.placeLogAt((LevelWriter)level, (BlockPos)stumpPos, (RandomSource)random, (TreeConfiguration)config);
                        this.logPosSet.add(stumpPos.m_7949_());
                        TreeUtil.setDirtAt((LevelAccessor)level, (BlockPos)stumpPos.m_7495_());
                        BlockPos sideStumpPos = stumpPos.m_121945_(direction.m_122427_());
                        if (random.m_188499_() && CherryTreeFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)sideStumpPos.m_7495_()) && TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)sideStumpPos)) {
                            TreeUtil.placeLogAt((LevelWriter)level, (BlockPos)sideStumpPos, (RandomSource)random, (TreeConfiguration)config);
                            this.logPosSet.add(sideStumpPos.m_7949_());
                            TreeUtil.setDirtAt((LevelAccessor)level, (BlockPos)sideStumpPos.m_7495_());
                        }
                        if (random.m_188499_() && TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)stumpPos.m_7494_())) {
                            TreeUtil.placeLogAt((LevelWriter)level, (BlockPos)stumpPos.m_7494_(), (RandomSource)random, (TreeConfiguration)config);
                            this.logPosSet.add(stumpPos.m_7494_().m_7949_());
                        }
                    }
                });
                Direction.Plane.HORIZONTAL.m_122557_().forEach(direction -> {
                    int newHeight = random.m_188499_() ? height + random.m_188503_(2) : height - random.m_188503_(2);
                    BlockPos newPos = this.createCherryBranch(newHeight, (LevelSimulatedRW)level, pos, (Direction)direction, random, config);
                    for (int i = 0; i < 5; ++i) {
                        this.createCherryLeaves((LevelSimulatedRW)level, newPos.m_6630_(2).m_6625_(i), random, i, config);
                    }
                });
                TreeUtil.updateLeaves((LevelAccessor)level, this.logPosSet);
                HashSet set3 = Sets.newHashSet();
                BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
                    set3.add(p_225290_.m_7949_());
                    level.m_7731_(p_225290_, p_225291_, 19);
                };
                if (!config.f_68187_.isEmpty()) {
                    TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)level, biconsumer3, random, this.logPosSet, (Set)Sets.newHashSet(), (Set)Sets.newHashSet());
                    config.f_68187_.forEach(decorator -> decorator.m_214187_(decoratorContext));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createCherryLeaves(LevelSimulatedRW level, BlockPos pos, RandomSource random, int leafLevel, TreeConfiguration config) {
        int leafSize = 2;
        for (int k = -leafSize; k <= leafSize; ++k) {
            for (int j = -leafSize; j <= leafSize; ++j) {
                if (leafLevel == 2) {
                    TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)pos.m_7918_(k, 0, j), (RandomSource)random, (TreeConfiguration)config);
                    continue;
                }
                if (leafLevel > 1 && leafLevel < 4 && (Math.abs(k) != leafSize || Math.abs(j) != leafSize)) {
                    TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)pos.m_7918_(k, 0, j), (RandomSource)random, (TreeConfiguration)config);
                    continue;
                }
                if ((leafLevel == 1 || leafLevel == 4) && Math.abs(k) <= 1 && Math.abs(j) <= 1) {
                    if ((Math.abs(k) == 1 && Math.abs(j) == 1 && leafLevel == 4 || Math.abs(k) == 2 && Math.abs(j) == 2) && !random.m_188499_()) continue;
                    TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)pos.m_7918_(k, 0, j), (RandomSource)random, (TreeConfiguration)config);
                    continue;
                }
                if (leafLevel != 1) continue;
                if (random.m_188503_(3) == 0 && (Math.abs(k) == 1 && Math.abs(j) == 2 || Math.abs(k) == 2 && Math.abs(j) == 1)) {
                    TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)pos.m_7918_(k, 0, j), (RandomSource)random, (TreeConfiguration)config);
                    continue;
                }
                if (random.m_188503_(4) == 0 || (Math.abs(k) != 0 || Math.abs(j) != 2) && (Math.abs(k) != 2 || Math.abs(j) != 0)) continue;
                TreeUtil.placeLeafAt((LevelSimulatedRW)level, (BlockPos)pos.m_7918_(k, 0, j), (RandomSource)random, (TreeConfiguration)config);
            }
        }
    }

    private BlockPos createCherryBranch(int height, LevelSimulatedRW worldIn, BlockPos pos, Direction direction, RandomSource rand, TreeConfiguration config) {
        int i;
        int logX = pos.m_123341_();
        int logZ = pos.m_123343_();
        int logY = pos.m_123342_() + height - 1;
        int length = 4 + rand.m_188503_(3) + rand.m_188503_(3);
        BlockPos blockpos = new BlockPos(logX, logY, logZ);
        for (i = 0; i < length; ++i) {
            blockpos = new BlockPos(logX, logY, logZ);
            this.createHorizontalLog(worldIn, blockpos, direction, rand, config);
            if (rand.m_188503_(4) != 0) {
                ++logY;
            }
            if (direction.m_122434_() == Direction.Axis.X) {
                logX += rand.m_188503_(2) * direction.m_122421_().m_122540_();
                continue;
            }
            logZ += rand.m_188503_(2) * direction.m_122421_().m_122540_();
        }
        for (i = 0; i < 3; ++i) {
            blockpos = new BlockPos(logX, logY, logZ);
            this.createHorizontalLog(worldIn, blockpos, direction, rand, config);
            ++logY;
        }
        return blockpos.m_121945_(direction);
    }

    private void createHorizontalLog(LevelSimulatedRW level, BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        int logX = pos.m_123341_();
        int logY = pos.m_123342_();
        int logZ = pos.m_123343_();
        for (int i = 0; i < 1; ++i) {
            BlockPos logPos = new BlockPos(logX += direction.m_122429_(), logY, logZ += direction.m_122431_());
            if (!TreeUtil.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)logPos)) continue;
            TreeUtil.placeLogAt((LevelWriter)level, (BlockPos)logPos, (RandomSource)random, (TreeConfiguration)config);
            this.logPosSet.add(logPos.m_7949_());
        }
    }
}

