/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import com.teamabnormals.environmental.common.block.HangingWisteriaLeavesBlock;
import com.teamabnormals.environmental.common.levelgen.util.WisteriaTreeUtil;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class WisteriaTreeFeature
extends Feature<TreeConfiguration> {
    private Set<BlockPos> logPosSet;

    public WisteriaTreeFeature(Codec<TreeConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        if (random.m_188503_(5) == 0 && ((Feature)EnvironmentalFeatures.BIG_WISTERIA_TREE.get()).m_142674_(context)) {
            return true;
        }
        BlockState vine = WisteriaTreeFeature.getHangingWisteriaLeavesState(random, pos, config);
        this.logPosSet = Sets.newHashSet();
        int height = random.m_188503_(7) + 5;
        boolean flag = true;
        if (pos.m_123342_() >= 1 && pos.m_123342_() + height + 1 <= world.m_151558_()) {
            for (int j = pos.m_123342_(); j <= pos.m_123342_() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.m_123342_()) {
                    k = 0;
                }
                if (j >= pos.m_123342_() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.m_123341_() - k; l <= pos.m_123341_() + k && flag; ++l) {
                    for (int i1 = pos.m_123343_() - k; i1 <= pos.m_123343_() + k && flag; ++i1) {
                        if (j >= 0 && j < world.m_151558_()) {
                            if (TreeUtil.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtil.isValidGround((LevelAccessor)world, (BlockPos)pos.m_7495_(), (SaplingBlock)((SaplingBlock)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get())) && pos.m_123342_() < world.m_151558_() - height - 1) {
                TreeUtil.setDirtAt((LevelAccessor)world, (BlockPos)pos.m_7495_());
                for (int y = 4; y > -4; --y) {
                    for (int x = 4; x > -4; --x) {
                        for (int z = 4; z > -4; --z) {
                            int n = y > 0 ? y * y : 0;
                            if (!(Math.sqrt(x * x + n + z * z) <= 4.0)) continue;
                            BlockPos leafPos = pos.m_7918_(x, y + height, z);
                            boolean place = true;
                            if (y < 0 && (place = TreeUtil.isLeaves((LevelSimulatedReader)world, (BlockPos)leafPos.m_7918_(0, 1, 0))) && random.m_188503_(Math.abs(y) + 1) != 0) {
                                place = false;
                                if (random.m_188503_(4) == 0 && !TreeUtil.isLog((LevelSimulatedReader)world, (BlockPos)leafPos)) {
                                    WisteriaTreeUtil.placeVines((LevelSimulatedRW)world, random, leafPos, config.f_161213_.m_213972_(random, pos));
                                }
                            }
                            if (!place) continue;
                            WisteriaTreeUtil.placeLeafAt((LevelSimulatedRW)world, leafPos, config.f_161213_.m_213972_(random, pos));
                        }
                    }
                }
                for (int i2 = 0; i2 < height; ++i2) {
                    if (!TreeUtil.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos.m_6630_(i2))) continue;
                    TreeUtil.placeLogAt((LevelWriter)world, (BlockPos)pos.m_6630_(i2), (RandomSource)random, (TreeConfiguration)config);
                    this.logPosSet.add(pos.m_6630_(i2).m_7949_());
                }
                this.placeBranch((LevelSimulatedRW)world, random, pos.m_7495_(), pos.m_6630_(height).m_123342_(), config);
                if (random.m_188503_(4) == 0) {
                    this.placeBranch((LevelSimulatedRW)world, random, pos.m_7495_(), pos.m_6630_(height).m_123342_(), config);
                }
                BlockPos startPos = pos.m_6630_(height);
                for (BlockPos blockpos : BlockPos.m_121976_((int)(startPos.m_123341_() - 10), (int)(startPos.m_123342_() - 10), (int)(startPos.m_123343_() - 10), (int)(startPos.m_123341_() + 10), (int)(startPos.m_123342_() + 10), (int)(startPos.m_123343_() + 10))) {
                    if (!world.m_8055_(blockpos).m_60795_() || !WisteriaTreeFeature.isLeaves((LevelSimulatedReader)world, blockpos.m_7494_(), config, random) || random.m_188503_(4) != 0) continue;
                    if (world.m_8055_(blockpos).m_60795_()) {
                        TreeUtil.setForcedState((LevelWriter)world, (BlockPos)blockpos, (BlockState)((BlockState)vine.m_61124_(HangingWisteriaLeavesBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)));
                    }
                    if (!world.m_8055_(blockpos.m_7495_()).m_60795_() || random.m_188503_(2) != 0) continue;
                    TreeUtil.setForcedState((LevelWriter)world, (BlockPos)blockpos.m_7495_(), (BlockState)((BlockState)vine.m_61124_(HangingWisteriaLeavesBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)));
                }
                WisteriaTreeUtil.updateLeaves((LevelAccessor)world, this.logPosSet);
                HashSet set3 = Sets.newHashSet();
                BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
                    set3.add(p_225290_.m_7949_());
                    world.m_7731_(p_225290_, p_225291_, 19);
                };
                if (!config.f_68187_.isEmpty()) {
                    TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)world, biconsumer3, random, this.logPosSet, (Set)Sets.newHashSet(), (Set)Sets.newHashSet());
                    config.f_68187_.forEach(decorator -> decorator.m_214187_(decoratorContext));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isLeaves(LevelSimulatedReader worldIn, BlockPos pos, TreeConfiguration config, RandomSource random) {
        if (worldIn instanceof LevelReader) {
            return worldIn.m_7433_(pos, state -> state == config.f_161213_.m_213972_(random, pos));
        }
        return worldIn.m_7433_(pos, p_227223_0_ -> config.f_161213_.m_213972_(random, pos) == p_227223_0_);
    }

    private void placeBranch(LevelSimulatedRW world, RandomSource random, BlockPos pos, int treeHeight, TreeConfiguration config) {
        int heightOffset = random.m_188503_(3);
        BlockPos[] startPositions = new BlockPos[]{new BlockPos(pos.m_123341_() - 1, treeHeight - heightOffset, pos.m_123343_()), new BlockPos(pos.m_123341_() + 1, treeHeight - heightOffset, pos.m_123343_()), new BlockPos(pos.m_123341_(), treeHeight - heightOffset, pos.m_123343_() - 1), new BlockPos(pos.m_123341_(), treeHeight - heightOffset, pos.m_123343_() + 1), new BlockPos(pos.m_123341_() - 1, treeHeight - heightOffset, pos.m_123343_() - 1), new BlockPos(pos.m_123341_() + 1, treeHeight - heightOffset, pos.m_123343_() - 1), new BlockPos(pos.m_123341_() - 1, treeHeight - heightOffset, pos.m_123343_() + 1), new BlockPos(pos.m_123341_() + 1, treeHeight - heightOffset, pos.m_123343_() + 1)};
        BlockPos startPos = startPositions[random.m_188503_(8)];
        if (WisteriaTreeUtil.isAirOrLeavesOrReplaceable((LevelSimulatedReader)world, startPos)) {
            boolean vines = random.m_188503_(6) != 5;
            BlockPos placePos = startPos;
            for (int y = treeHeight - heightOffset; y <= treeHeight; ++y) {
                placePos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
                if (!WisteriaTreeUtil.isAirOrLeavesOrReplaceable((LevelSimulatedReader)world, placePos)) continue;
                TreeUtil.placeLogAt((LevelWriter)world, (BlockPos)placePos, (RandomSource)random, (TreeConfiguration)config);
                this.logPosSet.add(placePos.m_7949_());
            }
            WisteriaTreeUtil.placeLeafAt(world, placePos.m_7494_(), config.f_161213_.m_213972_(random, pos));
            if (vines) {
                WisteriaTreeUtil.placeVines(world, random, startPos.m_7495_(), config.f_161213_.m_213972_(random, pos));
            }
        }
    }

    public static BlockState getHangingWisteriaLeavesState(RandomSource random, BlockPos pos, TreeConfiguration config) {
        BlockState leafState = config.f_161213_.m_213972_(random, pos);
        if (leafState.m_60713_((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get())) {
            return ((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get()).m_49966_();
        }
        if (leafState.m_60713_((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get())) {
            return ((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get()).m_49966_();
        }
        if (leafState.m_60713_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get())) {
            return ((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get()).m_49966_();
        }
        return ((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get()).m_49966_();
    }
}

