/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.network.message;

import com.teamabnormals.environmental.common.network.ClientNetworkHandler;
import com.teamabnormals.environmental.common.network.message.CAcknowledgeEnvironmentalMessage;
import com.teamabnormals.environmental.common.network.message.EnvironmentalLoginMessage;
import com.teamabnormals.environmental.common.slabfish.BackpackType;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.core.Environmental;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SSyncBackpackTypeMessage
implements EnvironmentalLoginMessage {
    private final BackpackType[] backpackTypes;
    private int loginIndex;

    public SSyncBackpackTypeMessage() {
        this(SlabfishManager.get(LogicalSide.SERVER).getAllBackpackTypes());
    }

    private SSyncBackpackTypeMessage(BackpackType[] backpackTypes) {
        this.backpackTypes = backpackTypes;
    }

    public static void serialize(SSyncBackpackTypeMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.backpackTypes.length);
        for (int i = 0; i < msg.backpackTypes.length; ++i) {
            msg.backpackTypes[i].writeTo(buf);
        }
    }

    public static SSyncBackpackTypeMessage deserialize(FriendlyByteBuf buf) {
        BackpackType[] backpackTypes = new BackpackType[buf.m_130242_()];
        for (int i = 0; i < backpackTypes.length; ++i) {
            backpackTypes[i] = BackpackType.readFrom(buf);
        }
        return new SSyncBackpackTypeMessage(backpackTypes);
    }

    public static void handlePlay(SSyncBackpackTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncBackpackType(msg, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleLogin(SSyncBackpackTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncBackpackType(msg, (NetworkEvent.Context)ctx.get()));
        Environmental.LOGIN.reply((Object)new CAcknowledgeEnvironmentalMessage(), ctx.get());
        ctx.get().setPacketHandled(true);
    }

    public BackpackType[] getBackpackTypes() {
        return this.backpackTypes;
    }

    @Override
    public int getLoginIndex() {
        return this.loginIndex;
    }

    @Override
    public void setLoginIndex(int loginIndex) {
        this.loginIndex = loginIndex;
    }
}

