/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.network.message;

import com.teamabnormals.environmental.common.network.ClientNetworkHandler;
import com.teamabnormals.environmental.common.network.message.CAcknowledgeEnvironmentalMessage;
import com.teamabnormals.environmental.common.network.message.EnvironmentalLoginMessage;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.core.Environmental;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SSyncSlabfishTypeMessage
implements EnvironmentalLoginMessage {
    private final SlabfishType[] slabfishTypes;
    private int loginIndex;

    public SSyncSlabfishTypeMessage() {
        this(SlabfishManager.get(LogicalSide.SERVER).getAllSlabfishTypes());
    }

    private SSyncSlabfishTypeMessage(SlabfishType[] slabfishTypes) {
        this.slabfishTypes = slabfishTypes;
    }

    public static void serialize(SSyncSlabfishTypeMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.slabfishTypes.length);
        for (int i = 0; i < msg.slabfishTypes.length; ++i) {
            msg.slabfishTypes[i].writeTo(buf);
        }
    }

    public static SSyncSlabfishTypeMessage deserialize(FriendlyByteBuf buf) {
        SlabfishType[] slabfishTypes = new SlabfishType[buf.m_130242_()];
        for (int i = 0; i < slabfishTypes.length; ++i) {
            slabfishTypes[i] = SlabfishType.readFrom(buf);
        }
        return new SSyncSlabfishTypeMessage(slabfishTypes);
    }

    public static void handlePlay(SSyncSlabfishTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncSlabfishType(msg, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public static void handleLogin(SSyncSlabfishTypeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientNetworkHandler.handleSyncSlabfishType(msg, (NetworkEvent.Context)ctx.get()));
        Environmental.LOGIN.reply((Object)new CAcknowledgeEnvironmentalMessage(), ctx.get());
        ctx.get().setPacketHandled(true);
    }

    public SlabfishType[] getSlabfishTypes() {
        return this.slabfishTypes;
    }

    @Override
    public int getLoginIndex() {
        return this.loginIndex;
    }

    @Override
    public void setLoginIndex(int loginIndex) {
        this.loginIndex = loginIndex;
    }
}

