/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishRarity;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

public class SlabfishType
implements Predicate<SlabfishConditionContext> {
    private final boolean translucent;
    private final ResourceLocation customBackpack;
    private final SlabfishRarity rarity;
    private final boolean tradable;
    private final boolean modLoaded;
    private final int priority;
    private final SlabfishCondition[] conditions;
    private final LazyLoadedValue<ResourceLocation> textureLocation = new LazyLoadedValue(() -> new ResourceLocation(this.getRegistryName().m_135827_(), "type/" + this.getRegistryName().m_135815_()));
    private ResourceLocation registryName;
    private Component displayName;

    public SlabfishType(ResourceLocation registryName, SlabfishRarity rarity, @Nullable Component displayName, @Nullable ResourceLocation customBackpack, boolean translucent, boolean tradable, boolean modLoaded, int priority, SlabfishCondition[] conditions) {
        this.registryName = registryName;
        this.rarity = rarity;
        this.displayName = displayName;
        this.customBackpack = customBackpack;
        this.translucent = translucent;
        this.tradable = tradable;
        this.modLoaded = modLoaded;
        this.priority = priority;
        this.conditions = conditions;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SlabfishType readFrom(FriendlyByteBuf buf) {
        ResourceLocation registryName = buf.m_130281_();
        Component displayName = buf.m_130238_();
        ResourceLocation customBackpack = buf.readBoolean() ? buf.m_130281_() : null;
        boolean translucent = buf.readBoolean();
        SlabfishRarity rarity = SlabfishRarity.byId(buf.m_130242_());
        boolean modLoaded = buf.readBoolean();
        int priority = buf.m_130242_();
        return new SlabfishType(registryName, rarity, displayName, customBackpack, translucent, false, modLoaded, priority, new SlabfishCondition[0]);
    }

    @Override
    public boolean test(SlabfishConditionContext slabfishEntity) {
        for (SlabfishCondition condition : this.conditions) {
            if (condition.test(slabfishEntity)) continue;
            return false;
        }
        return true;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    SlabfishType setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        if (this.displayName == null) {
            this.displayName = Component.m_237113_((String)registryName.toString());
        }
        return this;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.m_13971_();
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    @Nullable
    public ResourceLocation getCustomBackpack() {
        return this.customBackpack;
    }

    public SlabfishRarity getRarity() {
        return this.rarity;
    }

    public boolean isTradable() {
        return this.tradable;
    }

    public boolean isModLoaded() {
        return this.modLoaded;
    }

    public int getPriority() {
        return this.priority;
    }

    public void writeTo(FriendlyByteBuf buf) {
        buf.m_130085_(this.registryName);
        buf.m_130083_(this.displayName);
        buf.writeBoolean(this.customBackpack != null);
        if (this.customBackpack != null) {
            buf.m_130085_(this.customBackpack);
        }
        buf.writeBoolean(this.translucent);
        buf.m_130130_(this.rarity.ordinal());
        buf.writeBoolean(this.modLoaded);
        buf.m_130130_(this.priority);
    }

    public String toString() {
        return "SlabfishType{registryName=" + this.registryName + ", displayName=" + this.displayName.getString() + ", rarity=" + this.rarity + ", modLoaded=" + this.modLoaded + ", priority=" + this.priority + "}";
    }

    public JsonObject serializeToJson() {
        JsonObject json = new JsonObject();
        json.addProperty("rarity", this.rarity.toString().toLowerCase(Locale.ROOT));
        if (this.getPriority() != -1) {
            json.addProperty("priority", (Number)this.priority);
        }
        if (!this.tradable) {
            json.addProperty("tradable", Boolean.valueOf(this.tradable));
        }
        json.add("displayName", Component.Serializer.m_130716_((Component)this.displayName));
        if (this.translucent) {
            json.addProperty("translucent", Boolean.valueOf(this.translucent));
        }
        if (!this.modLoaded) {
            json.addProperty("mod_loaded", Boolean.valueOf(this.modLoaded));
        }
        return json;
    }

    public SlabfishType save(Consumer<SlabfishType> consumer, ResourceLocation location) {
        SlabfishType type = new SlabfishType(location, this.rarity, this.displayName, this.customBackpack, this.translucent, this.tradable, this.modLoaded, this.priority, this.conditions);
        consumer.accept(type);
        return type;
    }

    public static class Deserializer
    implements JsonDeserializer<SlabfishType> {
        private static SlabfishRarity deserializeRarity(JsonElement element) throws JsonParseException {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new JsonSyntaxException("'rarity' expected to be a string");
            }
            String name = element.getAsString();
            for (SlabfishRarity rarity : SlabfishRarity.values()) {
                if (!rarity.name().equalsIgnoreCase(name)) continue;
                return rarity;
            }
            throw new JsonSyntaxException("Invalid slabfish rarity: " + name);
        }

        public SlabfishType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            if (!jsonObject.has("rarity")) {
                throw new JsonSyntaxException("'rarity' is required");
            }
            SlabfishRarity rarity = Deserializer.deserializeRarity(jsonObject.get("rarity"));
            Component displayName = jsonObject.has("displayName") ? (Component)context.deserialize(jsonObject.get("displayName"), Component.class) : null;
            ResourceLocation customBackpack = jsonObject.has("customBackpack") ? (ResourceLocation)context.deserialize(jsonObject.get("customBackpack"), ResourceLocation.class) : null;
            boolean translucent = jsonObject.has("translucent") && jsonObject.get("translucent").getAsBoolean();
            boolean tradable = !jsonObject.has("tradable") || jsonObject.get("tradable").getAsBoolean();
            boolean modLoaded = !jsonObject.has("mod") || ModList.get().isLoaded(jsonObject.get("mod").getAsString());
            int priority = jsonObject.has("priority") ? jsonObject.get("priority").getAsInt() : 0;
            SlabfishCondition[] conditions = jsonObject.has("conditions") ? (SlabfishCondition[])context.deserialize(jsonObject.get("conditions"), SlabfishCondition[].class) : new SlabfishCondition[]{};
            return new SlabfishType(new ResourceLocation("environmental", "slabfish"), rarity, displayName, customBackpack, translucent, tradable, modLoaded, priority, conditions);
        }
    }
}

