/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.level.LightLayer;

public class SlabfishLightCondition
implements SlabfishCondition {
    private final Function<SlabfishConditionContext, Integer> lightGetter = context -> lightType == null ? context.getLight() : context.getLightFor(lightType);
    private final int minLight;
    private final int maxLight;

    private SlabfishLightCondition(int minLight, int maxLight, @Nullable LightLayer lightType) {
        this.minLight = minLight;
        this.maxLight = maxLight;
    }

    private static LightLayer deserializeLightType(JsonElement element) throws JsonParseException {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new JsonSyntaxException("Light type expected to be a string");
        }
        String name = element.getAsString();
        for (LightLayer lightType : LightLayer.values()) {
            if (!lightType.name().equalsIgnoreCase(name)) continue;
            return lightType;
        }
        throw new JsonSyntaxException("Invalid light type: " + name);
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if ((json.has("min") || json.has("max")) && json.has("value")) {
            throw new JsonSyntaxException("Either 'min' and 'max' or 'value' can be present.");
        }
        if (!(json.has("min") || json.has("max") || json.has("value"))) {
            throw new JsonSyntaxException("Either 'min' and 'max' or 'value' must be present.");
        }
        LightLayer lightType = null;
        if (json.has("lightType")) {
            lightType = SlabfishLightCondition.deserializeLightType(json.get("lightType"));
        }
        return json.has("value") ? new SlabfishLightCondition(json.get("value").getAsInt(), json.get("value").getAsInt(), lightType) : new SlabfishLightCondition(json.has("min") ? json.get("min").getAsInt() : Integer.MIN_VALUE, json.has("max") ? json.get("max").getAsInt() : Integer.MAX_VALUE, lightType);
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return this.lightGetter.apply(context) >= this.minLight && this.lightGetter.apply(context) <= this.maxLight;
    }
}

