/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.util.regex.Pattern;

public class SlabfishRenameCondition
implements SlabfishCondition {
    private final Pattern pattern;

    private SlabfishRenameCondition(Pattern pattern) {
        this.pattern = pattern;
    }

    private SlabfishRenameCondition(String[] names, boolean caseSensitive) {
        StringBuilder regexBuilder = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            regexBuilder.append("\\b").append(names[i]);
            if (i >= names.length - 1) continue;
            regexBuilder.append("|");
        }
        this.pattern = Pattern.compile(regexBuilder.toString(), (!caseSensitive ? 2 : 0) | 0x40);
    }

    public static SlabfishCondition deserialize(JsonObject json, JsonDeserializationContext context) {
        if ((json.has("names") || json.has("caseSensitive")) && json.has("regex")) {
            throw new JsonSyntaxException("Either 'regex' or 'names' and 'caseSensitive' can be present.");
        }
        if (!(json.has("names") || json.has("caseSensitive") || json.has("regex"))) {
            throw new JsonSyntaxException("Either 'regex' or 'names' and 'caseSensitive' must be present.");
        }
        return json.has("regex") ? new SlabfishRenameCondition(Pattern.compile(json.get("regex").getAsString())) : new SlabfishRenameCondition((String[])context.deserialize(json.get("names"), String[].class), json.has("caseSensitive") && json.get("caseSensitive").getAsBoolean());
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return context.getEvent() == SlabfishConditionContext.Event.RENAME && this.pattern.matcher(context.getName()).matches();
    }
}

