/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="environmental")
public class EnvironmentalConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> biomeVariantsAlwaysSpawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> blockOnlyNaturalSpawns;
        public final ForgeConfigSpec.ConfigValue<Integer> koiHorizontalSerenityRange;
        public final ForgeConfigSpec.ConfigValue<Integer> koiVerticalSerenityRange;
        public final ForgeConfigSpec.ConfigValue<Boolean> serenityEffect;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            this.biomeVariantsAlwaysSpawn = builder.comment("Make biome variants of mobs like Husks always spawn in place of their original in their biomes").define("Biome variants always spawn", true);
            builder.push("koi");
            this.blockOnlyNaturalSpawns = builder.comment("Make Koi only block natural spawns").define("Block only natural spawns", true);
            this.koiHorizontalSerenityRange = builder.comment("Horizontal radius of Serenity effect in blocks").define("Horizontal serenity range (radius)", (Object)32);
            this.koiVerticalSerenityRange = builder.comment("Vertical radius of Serenity effect in blocks").define("Vertical serenity range (radius)", (Object)8);
            this.serenityEffect = builder.comment("If Koi exude Serenity as a potion effect").define("Serenity potion effect", true);
            builder.pop();
            builder.pop();
        }
    }
}

