/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(EnvironmentalBlockLoot::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(EnvironmentalEntityLoot::new, (Object)LootContextParamSets.f_81415_));

    public EnvironmentalLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    public List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    private static class EnvironmentalEntityLoot
    extends EntityLoot {
        private EnvironmentalEntityLoot() {
        }

        public void addTables() {
            this.m_124371_((EntityType)EnvironmentalEntityTypes.DEER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.VENISON.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)EnvironmentalEntityTypes.DUCK.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.DUCK.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)EnvironmentalEntityTypes.FENNEC_FOX.get(), LootTable.m_79147_());
            this.m_124371_((EntityType)EnvironmentalEntityTypes.KOI.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.KOI.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f))));
            this.m_124371_((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), LootTable.m_79147_());
            this.m_124371_((EntityType)EnvironmentalEntityTypes.TAPIR.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42485_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)EnvironmentalEntityTypes.YAK.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.YAK_HAIR.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42579_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)EnvironmentalEntityTypes.ZOMBIE_DEER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42583_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_(EntityType.f_20494_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.MUSIC_DISC_LEAVING_HOME.get()))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_204077_(EntityTypeTags.f_13120_)))));
        }

        public Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(entity -> ForgeRegistries.ENTITY_TYPES.getKey(entity).m_135827_().equals("environmental")).collect(Collectors.toSet());
        }
    }

    private static class EnvironmentalBlockLoot
    extends BlockLoot {
        private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        private static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_})).m_7818_(HAS_SILK_TOUCH).m_81807_();
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        private EnvironmentalBlockLoot() {
        }

        public void addTables() {
            this.m_124288_((Block)EnvironmentalBlocks.CARTWHEEL.get());
            this.m_124288_((Block)EnvironmentalBlocks.BLUEBELL.get());
            this.m_124288_((Block)EnvironmentalBlocks.VIOLET.get());
            this.m_124288_((Block)EnvironmentalBlocks.DIANTHUS.get());
            this.m_124288_((Block)EnvironmentalBlocks.RED_LOTUS_FLOWER.get());
            this.m_124288_((Block)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get());
            this.m_124288_((Block)EnvironmentalBlocks.YELLOW_HIBISCUS.get());
            this.m_124288_((Block)EnvironmentalBlocks.ORANGE_HIBISCUS.get());
            this.m_124288_((Block)EnvironmentalBlocks.RED_HIBISCUS.get());
            this.m_124288_((Block)EnvironmentalBlocks.PINK_HIBISCUS.get());
            this.m_124288_((Block)EnvironmentalBlocks.MAGENTA_HIBISCUS.get());
            this.m_124288_((Block)EnvironmentalBlocks.PURPLE_HIBISCUS.get());
            this.m_124175_((Block)EnvironmentalBlocks.BIRD_OF_PARADISE.get(), block -> EnvironmentalBlockLoot.m_124161_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_124175_((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get(), block -> EnvironmentalBlockLoot.m_124161_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_124175_((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get(), block -> EnvironmentalBlockLoot.m_124161_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_124175_((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get(), block -> EnvironmentalBlockLoot.m_124161_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_124175_((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get(), block -> EnvironmentalBlockLoot.m_124161_((Block)block, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_CARTWHEEL.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_BLUEBELL.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_VIOLET.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_DIANTHUS.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_RED_LOTUS_FLOWER.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_WHITE_LOTUS_FLOWER.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_YELLOW_HIBISCUS.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_ORANGE_HIBISCUS.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_RED_HIBISCUS.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_PINK_HIBISCUS.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_MAGENTA_HIBISCUS.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_PURPLE_HIBISCUS.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_BIRD_OF_PARADISE.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_PINK_DELPHINIUM.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_BLUE_DELPHINIUM.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_PURPLE_DELPHINIUM.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_WHITE_DELPHINIUM.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_CATTAIL.get());
            this.m_124288_((Block)EnvironmentalBlocks.SMOOTH_MUD.get());
            this.m_124175_((Block)EnvironmentalBlocks.SMOOTH_MUD_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.SMOOTH_MUD_VERTICAL_SLAB.get(), EnvironmentalBlockLoot::createVerticalSlabItemTable);
            this.m_124288_((Block)EnvironmentalBlocks.CHISELED_MUD_BRICKS.get());
            this.m_124288_((Block)EnvironmentalBlocks.SLABFISH_EFFIGY.get());
            this.m_124288_((Block)EnvironmentalBlocks.GRASS_THATCH.get());
            this.m_124288_((Block)EnvironmentalBlocks.GRASS_THATCH_STAIRS.get());
            this.m_124175_((Block)EnvironmentalBlocks.GRASS_THATCH_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.GRASS_THATCH_VERTICAL_SLAB.get(), EnvironmentalBlockLoot::createVerticalSlabItemTable);
            this.m_124288_((Block)EnvironmentalBlocks.CATTAIL_THATCH.get());
            this.m_124288_((Block)EnvironmentalBlocks.CATTAIL_THATCH_STAIRS.get());
            this.m_124175_((Block)EnvironmentalBlocks.CATTAIL_THATCH_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.CATTAIL_THATCH_VERTICAL_SLAB.get(), EnvironmentalBlockLoot::createVerticalSlabItemTable);
            this.m_124288_((Block)EnvironmentalBlocks.DUCKWEED_THATCH.get());
            this.m_124288_((Block)EnvironmentalBlocks.DUCKWEED_THATCH_STAIRS.get());
            this.m_124175_((Block)EnvironmentalBlocks.DUCKWEED_THATCH_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.DUCKWEED_THATCH_VERTICAL_SLAB.get(), EnvironmentalBlockLoot::createVerticalSlabItemTable);
            this.m_124175_((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get(), block -> EnvironmentalBlockLoot.m_124139_((Block)block, (Item)((Item)EnvironmentalItems.TRUFFLE.get())));
            this.m_124147_((Block)EnvironmentalBlocks.LARGE_LILY_PAD.get(), (ItemLike)Blocks.f_50196_);
            this.m_124147_((Block)EnvironmentalBlocks.GIANT_LILY_PAD.get(), (ItemLike)Blocks.f_50196_);
            this.m_124147_((Block)EnvironmentalBlocks.MYCELIUM_PATH.get(), (ItemLike)Blocks.f_50493_);
            this.m_124147_((Block)EnvironmentalBlocks.PODZOL_PATH.get(), (ItemLike)Blocks.f_50493_);
            this.m_124147_((Block)EnvironmentalBlocks.CATTAIL_SPROUTS.get(), (ItemLike)EnvironmentalItems.CATTAIL_SEEDS.get());
            this.m_124175_((Block)EnvironmentalBlocks.CATTAIL_SPROUTS.get(), block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EnvironmentalBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.CATTAIL_SEEDS.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.1f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2))))));
            this.m_124175_((Block)EnvironmentalBlocks.CATTAIL.get(), block -> EnvironmentalBlockLoot.m_124267_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)EnvironmentalBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.CATTAIL_SEEDS.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.25f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2))))));
            this.m_124175_((Block)EnvironmentalBlocks.TALL_CATTAIL.get(), block -> EnvironmentalBlockLoot.createDoublePlantWithOtherDrop(block, (Block)EnvironmentalBlocks.CATTAIL.get(), (Item)EnvironmentalItems.CATTAIL_SEEDS.get(), 2, 0.5f).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2)));
            this.m_124175_((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get(), x$0 -> BlockLoot.m_124286_((ItemLike)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.DUCKWEED.get(), x$0 -> BlockLoot.m_124286_((ItemLike)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get(), block -> EnvironmentalBlockLoot.createDoublePlantWithOtherDrop(block, Blocks.f_50034_, Items.f_42404_, 3, 0.125f));
            this.m_124175_((Block)EnvironmentalBlocks.TALL_DEAD_BUSH.get(), block -> EnvironmentalBlockLoot.createDoublePlantWithOtherDrop(block, Blocks.f_50036_, Items.f_42398_, 2, 0.125f));
            this.m_124288_((Block)EnvironmentalBlocks.CATTAIL_SEED_SACK.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_CRATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.DUCK_EGG_CRATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.TRUFFLE_CRATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.YAK_HAIR_BLOCK.get());
            this.m_124288_((Block)EnvironmentalBlocks.YAK_HAIR_RUG.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_PLANKS.get());
            this.m_124288_((Block)EnvironmentalBlocks.VERTICAL_WILLOW_PLANKS.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_LOG.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_WOOD.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD.get());
            this.m_124288_((Block)((RegistryObject)EnvironmentalBlocks.WILLOW_SIGNS.getFirst()).get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_PRESSURE_PLATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_TRAPDOOR.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_BUTTON.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_STAIRS.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_FENCE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_FENCE_GATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_BOARDS.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_POST.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_WILLOW_POST.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_HEDGE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_LEAF_CARPET.get());
            this.m_124175_((Block)EnvironmentalBlocks.WILLOW_LEAF_PILE.get(), EnvironmentalBlockLoot::createLeafPileDrops);
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_SAPLING.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_WILLOW_SAPLING.get());
            this.m_124288_((Block)EnvironmentalBlocks.WILLOW_LADDER.get());
            this.m_124175_((Block)EnvironmentalBlocks.WILLOW_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.WILLOW_VERTICAL_SLAB.get(), EnvironmentalBlockLoot::createVerticalSlabItemTable);
            this.m_124175_((Block)EnvironmentalBlocks.WILLOW_DOOR.get(), BlockLoot::m_124137_);
            this.m_124175_((Block)EnvironmentalBlocks.WILLOW_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)EnvironmentalBlocks.WILLOW_CHESTS.getFirst()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)EnvironmentalBlocks.WILLOW_CHESTS.getSecond()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.WILLOW_BOOKSHELF.get(), block -> EnvironmentalBlockLoot.m_176042_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_124175_((Block)EnvironmentalBlocks.WILLOW_LEAVES.get(), block -> EnvironmentalBlockLoot.m_124157_((Block)block, (Block)((Block)EnvironmentalBlocks.WILLOW_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get(), x$0 -> BlockLoot.m_124286_((ItemLike)x$0));
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_PLANKS.get());
            this.m_124288_((Block)EnvironmentalBlocks.VERTICAL_CHERRY_PLANKS.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_LOG.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_WOOD.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_CHERRY_LOG.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_CHERRY_WOOD.get());
            this.m_124288_((Block)((RegistryObject)EnvironmentalBlocks.CHERRY_SIGNS.getFirst()).get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_PRESSURE_PLATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_TRAPDOOR.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_BUTTON.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_STAIRS.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_FENCE.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_FENCE_GATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_BOARDS.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_POST.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_CHERRY_POST.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_HEDGE.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_LEAF_CARPET.get());
            this.m_124175_((Block)EnvironmentalBlocks.CHERRY_LEAF_PILE.get(), EnvironmentalBlockLoot::createLeafPileDrops);
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_SAPLING.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_CHERRY_SAPLING.get());
            this.m_124288_((Block)EnvironmentalBlocks.CHERRY_LADDER.get());
            this.m_124175_((Block)EnvironmentalBlocks.CHERRY_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.CHERRY_VERTICAL_SLAB.get(), EnvironmentalBlockLoot::createVerticalSlabItemTable);
            this.m_124175_((Block)EnvironmentalBlocks.CHERRY_DOOR.get(), BlockLoot::m_124137_);
            this.m_124175_((Block)EnvironmentalBlocks.CHERRY_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)EnvironmentalBlocks.CHERRY_CHESTS.getFirst()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)EnvironmentalBlocks.CHERRY_CHESTS.getSecond()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.CHERRY_BOOKSHELF.get(), block -> EnvironmentalBlockLoot.m_176042_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_124175_((Block)EnvironmentalBlocks.CHERRY_LEAVES.get(), block -> EnvironmentalBlockLoot.createCherryLeavesDrop(block, (Block)EnvironmentalBlocks.CHERRY_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_PLANKS.get());
            this.m_124288_((Block)EnvironmentalBlocks.VERTICAL_WISTERIA_PLANKS.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_LOG.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_WOOD.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD.get());
            this.m_124288_((Block)((RegistryObject)EnvironmentalBlocks.WISTERIA_SIGNS.getFirst()).get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_PRESSURE_PLATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_TRAPDOOR.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_BUTTON.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_STAIRS.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_FENCE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_FENCE_GATE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_BOARDS.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_POST.get());
            this.m_124288_((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_POST.get());
            this.m_124288_((Block)EnvironmentalBlocks.PINK_WISTERIA_HEDGE.get());
            this.m_124288_((Block)EnvironmentalBlocks.BLUE_WISTERIA_HEDGE.get());
            this.m_124288_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_HEDGE.get());
            this.m_124288_((Block)EnvironmentalBlocks.WHITE_WISTERIA_HEDGE.get());
            this.m_124288_((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAF_CARPET.get());
            this.m_124288_((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_CARPET.get());
            this.m_124288_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_CARPET.get());
            this.m_124288_((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_CARPET.get());
            this.m_124175_((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE.get(), EnvironmentalBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE.get(), EnvironmentalBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE.get(), EnvironmentalBlockLoot::createLeafPileDrops);
            this.m_124175_((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE.get(), EnvironmentalBlockLoot::createLeafPileDrops);
            this.m_124288_((Block)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get());
            this.m_124288_((Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get());
            this.m_124288_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get());
            this.m_124288_((Block)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_PINK_WISTERIA_SAPLING.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_BLUE_WISTERIA_SAPLING.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_PURPLE_WISTERIA_SAPLING.get());
            this.m_124252_((Block)EnvironmentalBlocks.POTTED_WHITE_WISTERIA_SAPLING.get());
            this.m_124288_((Block)EnvironmentalBlocks.WISTERIA_LADDER.get());
            this.m_124175_((Block)EnvironmentalBlocks.WISTERIA_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.WISTERIA_VERTICAL_SLAB.get(), EnvironmentalBlockLoot::createVerticalSlabItemTable);
            this.m_124175_((Block)EnvironmentalBlocks.WISTERIA_DOOR.get(), BlockLoot::m_124137_);
            this.m_124175_((Block)EnvironmentalBlocks.WISTERIA_BEEHIVE.get(), x$0 -> BlockLoot.m_124300_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)EnvironmentalBlocks.WISTERIA_CHESTS.getFirst()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)((RegistryObject)EnvironmentalBlocks.WISTERIA_CHESTS.getSecond()).get(), x$0 -> BlockLoot.m_124292_((Block)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.WISTERIA_BOOKSHELF.get(), block -> EnvironmentalBlockLoot.m_176042_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_124175_((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get(), block -> EnvironmentalBlockLoot.m_124157_((Block)block, (Block)((Block)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get(), block -> EnvironmentalBlockLoot.m_124157_((Block)block, (Block)((Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get(), block -> EnvironmentalBlockLoot.m_124157_((Block)block, (Block)((Block)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get(), block -> EnvironmentalBlockLoot.m_124157_((Block)block, (Block)((Block)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
            this.m_124175_((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLoot.m_124286_((ItemLike)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLoot.m_124286_((ItemLike)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLoot.m_124286_((ItemLike)x$0));
            this.m_124175_((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLoot.m_124286_((ItemLike)x$0));
        }

        protected static LootTable.Builder createCherryLeavesDrop(Block block, Block sapling, float ... saplingChances) {
            return EnvironmentalBlockLoot.m_124157_((Block)block, (Block)sapling, (float[])saplingChances).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)EnvironmentalBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)EnvironmentalItems.CHERRIES.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.05f, 0.055555556f, 0.0625f, 0.08333334f, 0.25f}))));
        }

        protected static LootTable.Builder createLeafPileDrops(Block block) {
            return EnvironmentalBlockLoot.m_236227_((Block)block, (LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS)));
        }

        protected static LootTable.Builder createVerticalSlabItemTable(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)EnvironmentalBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE)))))));
        }

        protected static LootTable.Builder createDoublePlantWithOtherDrop(Block block, Block grass, Item drop, int count, float chance) {
            AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)grass).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS)))).m_7170_(((LootPoolSingletonContainer.Builder)EnvironmentalBlockLoot.m_236224_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)drop))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance)));
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)builder).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{block}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, 1, 0)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)builder).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{block}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, -1, 0))));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("environmental")).collect(Collectors.toSet());
        }
    }
}

