/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomes;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.FilledBucketTrigger;
import net.minecraft.advancements.critereon.FishingRodHookedTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlacedBlockTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class EnvironmentalAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] BREEDABLE_ANIMALS = new EntityType[]{(EntityType)EnvironmentalEntityTypes.SLABFISH.get(), (EntityType)EnvironmentalEntityTypes.DUCK.get(), (EntityType)EnvironmentalEntityTypes.DEER.get(), (EntityType)EnvironmentalEntityTypes.YAK.get()};

    public EnvironmentalAdvancementModifierProvider(DataGenerator generator) {
        super(generator, "environmental");
    }

    protected void registerEntries() {
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, MobEffectsPredicate.m_56552_().m_56553_(MobEffects.f_19616_).m_56553_((MobEffect)EnvironmentalMobEffects.PANIC.get()).m_56553_((MobEffect)EnvironmentalMobEffects.SERENITY.get())), new ICondition[0]);
        this.entry("nether/all_potions").selects(new String[]{"nether/all_potions"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, MobEffectsPredicate.m_56552_().m_56553_(MobEffects.f_19616_)), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        EnvironmentalItems.HELPER.getDeferredRegister().getEntries().forEach(registryObject -> {
            Item item = (Item)registryObject.get();
            if (item.m_41472_()) {
                balancedDiet.addCriterion(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)item));
            }
        });
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder breedAllAnimals = CriteriaModifier.builder((String)this.modId);
        for (EntityType<?> entityType : BREEDABLE_ANIMALS) {
            breedAllAnimals.addCriterion(ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_(), (CriterionTriggerInstance)BredAnimalsTrigger.TriggerInstance.m_18667_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType)));
        }
        this.entry("husbandry/bred_all_animals").selects(new String[]{"husbandry/bred_all_animals"}).addModifier((ObjectModifier)breedAllAnimals.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder adventuringTime = CriteriaModifier.builder((String)this.modId);
        EnvironmentalBiomes.HELPER.getDeferredRegister().getEntries().forEach(biome -> {
            ResourceLocation key = ForgeRegistries.BIOMES.getKey((Object)((Biome)biome.get()));
            adventuringTime.addCriterion(key.m_135815_(), (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)key))));
        });
        this.entry("adventure/adventuring_time").selects(new String[]{"adventure/adventuring_time"}).addModifier((ObjectModifier)adventuringTime.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        this.entry("husbandry/fishy_business").selects(new String[]{"husbandry/fishy_business"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("koi", (CriterionTriggerInstance)FishingRodHookedTrigger.TriggerInstance.m_40447_((ItemPredicate)ItemPredicate.f_45028_, (EntityPredicate)EntityPredicate.f_36550_, (ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.KOI.get()}).m_45077_())).addIndexedRequirements(0, false, new String[]{"koi"}).build(), new ICondition[0]);
        this.entry("husbandry/tactical_fishing").selects(new String[]{"husbandry/tactical_fishing"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("koi_bucket", (CriterionTriggerInstance)FilledBucketTrigger.TriggerInstance.m_38793_((ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.KOI_BUCKET.get()}).m_45077_())).addCriterion("slabfish_bucket", (CriterionTriggerInstance)FilledBucketTrigger.TriggerInstance.m_38793_((ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.SLABFISH_BUCKET.get()}).m_45077_())).addIndexedRequirements(0, false, new String[]{"koi_bucket", "slabfish_bucket"}).build(), new ICondition[0]);
        this.entry("husbandry/plant_seed").selects(new String[]{"husbandry/plant_seed"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("cattail_sprouts", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)EnvironmentalBlocks.CATTAIL_SPROUTS.get()))).addIndexedRequirements(0, false, new String[]{"cattail_sprouts"}).build(), new ICondition[0]);
    }
}

