/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomeModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalBiomeModifierProvider {
    private static final RegistryAccess ACCESS = RegistryAccess.m_206197_();
    private static final Registry<Biome> BIOMES = ACCESS.m_175515_(Registry.f_122885_);
    private static final Registry<PlacedFeature> PLACED_FEATURES = ACCESS.m_175515_(Registry.f_194567_);
    private static final Registry<EntityType<?>> ENTITY_TYPES = ACCESS.m_175515_(ForgeRegistries.ENTITY_TYPES.getRegistryKey());
    private static final HashMap<ResourceLocation, BiomeModifier> MODIFIERS = new HashMap();

    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        EnvironmentalBiomeModifierProvider.addSpawn("slabfish", EnvironmentalBiomeTags.HAS_SLABFISH, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), 16, 2, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("duck", EnvironmentalBiomeTags.HAS_DUCK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 10, 3, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("duck_river", (ResourceKey<Biome>)Biomes.f_48208_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 1, 1, 2));
        EnvironmentalBiomeModifierProvider.addSpawn("deer", EnvironmentalBiomeTags.HAS_DEER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DEER.get(), 16, 4, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("yak", EnvironmentalBiomeTags.HAS_YAK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.YAK.get(), 8, 2, 4));
        EnvironmentalBiomeModifierProvider.addSpawn("yak_meadow", (ResourceKey<Biome>)Biomes.f_186754_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.YAK.get(), 2, 2, 4));
        EnvironmentalBiomeModifierProvider.removeSpawnInverted("pig", EnvironmentalBiomeTags.HAS_PIG, EntityType.f_20510_);
        EnvironmentalBiomeModifierProvider.removeSpawnInverted("sheep", EnvironmentalBiomeTags.HAS_SHEEP, EntityType.f_20520_);
        EnvironmentalBiomeModifierProvider.removeSpawnInverted("cow", EnvironmentalBiomeTags.HAS_COW, EntityType.f_20557_);
        EnvironmentalBiomeModifierProvider.removeSpawnInverted("chicken", EnvironmentalBiomeTags.HAS_CHICKEN, EntityType.f_20555_);
        EnvironmentalBiomeModifierProvider.addFeature("bluebell", (ResourceKey<Biome>)Biomes.f_48151_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BLUEBELL);
        EnvironmentalBiomeModifierProvider.addFeature("violet", (TagKey<Biome>)BiomeTags.f_207609_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_VIOLET);
        EnvironmentalBiomeModifierProvider.addFeature("warm_hibiscus", (ResourceKey<Biome>)Biomes.f_186769_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_HIBISCUS_WARM);
        EnvironmentalBiomeModifierProvider.addFeature("cool_hibiscus", (ResourceKey<Biome>)Biomes.f_48222_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_HIBISCUS_COOL);
        EnvironmentalBiomeModifierProvider.addFeature("cattails", EnvironmentalBiomeTags.HAS_CATTAILS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.CATTAILS);
        EnvironmentalBiomeModifierProvider.addFeature("tall_dead_bush", (ResourceKey<Biome>)Biomes.f_48203_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_TALL_DEAD_BUSH);
        EnvironmentalBiomeModifierProvider.addFeature("tall_dead_bush_badlands", (TagKey<Biome>)BiomeTags.f_207607_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_TALL_DEAD_BUSH_BADLANDS);
        EnvironmentalBiomeModifierProvider.addFeature("mycelium_sprouts", (ResourceKey<Biome>)Biomes.f_48215_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_MYCELIUM_SPROUTS);
        EnvironmentalBiomeModifierProvider.addFeature("mud_disk", EnvironmentalBiomeTags.HAS_MUD_DISK, GenerationStep.Decoration.UNDERGROUND_ORES, EnvironmentalFeatures.EnvironmentalPlacedFeatures.DISK_MUD);
        EnvironmentalBiomeModifierProvider.addFeature("swamp_vegetation", (ResourceKey<Biome>)Biomes.f_48207_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.HUGE_SWAMP_MUSHROOMS, EnvironmentalFeatures.EnvironmentalPlacedFeatures.TREES_SWAMP, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_DUCKWEED_SWAMP);
        EnvironmentalBiomeModifierProvider.addFeature("flower_forest_vegetation", (ResourceKey<Biome>)Biomes.f_48179_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_CARTWHEEL, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_DELPHINIUMS, EnvironmentalFeatures.EnvironmentalPlacedFeatures.TREES_WISTERIA);
        EnvironmentalBiomeModifierProvider.addFeature("savanna_vegetation", (TagKey<Biome>)BiomeTags.f_215816_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_ALLIUM, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_SAVANNA);
        EnvironmentalBiomeModifierProvider.addFeature("plains_vegetation", EnvironmentalBiomeTags.HAS_COW, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_PLAINS);
        EnvironmentalBiomeModifierProvider.addFeature("jungle_vegetation", (TagKey<Biome>)BiomeTags.f_207610_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BIRD_OF_PARADISE, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_JUNGLE);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"environmental", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)ACCESS), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, MODIFIERS);
    }

    @SafeVarargs
    private static void addFeature(String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        EnvironmentalBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(EnvironmentalBiomeModifierProvider.biomeSet(biome), EnvironmentalBiomeModifierProvider.featureSet(features), step));
    }

    @SafeVarargs
    private static void addFeature(String name, TagKey<Biome> biomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        EnvironmentalBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, biomes), EnvironmentalBiomeModifierProvider.featureSet(features), step));
    }

    private static void addSpawn(String name, ResourceKey<Biome> biome, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("add_spawn/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(EnvironmentalBiomeModifierProvider.biomeSet(biome), List.of(spawns)));
    }

    private static void addSpawn(String name, TagKey<Biome> tagKey, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("add_spawn/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, tagKey), List.of(spawns)));
    }

    private static void removeSpawnInverted(String name, TagKey<Biome> biomes, EntityType<?> ... spawns) {
        EnvironmentalBiomeModifierProvider.addModifier("remove_spawn/" + name, new EnvironmentalBiomeModifierTypes.InvertedRemoveSpawnsBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOMES, biomes), (HolderSet<EntityType<?>>)HolderSet.m_205800_(Stream.of(spawns).map(type -> ENTITY_TYPES.m_214121_((ResourceKey)ENTITY_TYPES.m_7854_(type).get())).collect(Collectors.toList()))));
    }

    private static void addModifier(String name, BiomeModifier modifier) {
        MODIFIERS.put(new ResourceLocation("environmental", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<Biome> biomeSet(ResourceKey<Biome> ... biomes) {
        return HolderSet.m_205800_(Stream.of(biomes).map(arg_0 -> BIOMES.m_214121_(arg_0)).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

