/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.mixin;

import com.teamabnormals.environmental.common.item.explorer.ThiefHoodItem;
import com.teamabnormals.environmental.core.registry.EnvironmentalAttributes;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"getVisibilityPercent"}, at={@At(value="TAIL")}, cancellable=true)
    private void getVisibilityMultiplier(@Nullable Entity lookingEntity, CallbackInfoReturnable<Double> cir) {
        ItemStack stack;
        Item item;
        double value = (Double)cir.getReturnValue();
        if (lookingEntity != null && (item = (stack = ((LivingEntity)this).m_6844_(EquipmentSlot.HEAD)).m_41720_()) instanceof ThiefHoodItem) {
            Collection modifiers = stack.m_41638_(EquipmentSlot.HEAD).get((Object)((Attribute)EnvironmentalAttributes.STEALTH.get()));
            if (modifiers.isEmpty()) {
                return;
            }
            double attribute = modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
            value *= 1.0 - Math.max(attribute, 0.0);
        }
        cir.setReturnValue((Object)value);
    }
}

