/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.mixin;

import com.teamabnormals.environmental.core.other.tags.EnvironmentalStructureTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin
extends LivingEntity {
    @Shadow
    @Final
    protected float[] f_21348_;

    protected MobEntityMixin(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="TAIL")})
    private void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty, CallbackInfo info) {
        ServerLevel serverLevel;
        Optional structures;
        int difficultyChance = difficulty.m_19048_().m_19028_() + 1;
        Level level = this.m_20193_();
        if (level instanceof ServerLevel && (structures = (serverLevel = (ServerLevel)level).m_5962_().m_175515_(Registry.f_235725_).m_203431_(EnvironmentalStructureTags.HAS_HEALER_POUCH)).isPresent()) {
            boolean valid = false;
            for (Holder structure : (HolderSet.Named)structures.get()) {
                if (structure == null || !serverLevel.m_215010_().m_220494_(this.m_20183_(), (Structure)structure.m_203334_()).m_73603_()) continue;
                valid = true;
            }
            if (valid && random.m_188500_() < (double)((float)difficultyChance * 0.01f)) {
                this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)EnvironmentalItems.HEALER_POUCH.get()));
                this.f_21348_[EquipmentSlot.CHEST.m_20749_()] = 1.0f;
            }
        }
    }
}

