/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.environmental.common.block.HangingWisteriaLeavesBlock;
import com.teamabnormals.environmental.common.entity.ai.goal.HuntTruffleGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.TemptGoldenCarrotGoal;
import com.teamabnormals.environmental.common.entity.animal.Koi;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class EnvironmentalEvents {
    protected static final Set<Block> DIRT_SPREADABLES = Sets.newHashSet((Object[])new Block[]{Blocks.f_50440_, Blocks.f_50195_});

    @SubscribeEvent
    public static void onPlayerBreak(PlayerEvent.BreakSpeed event) {
        if (event.getState().m_60734_() instanceof HangingWisteriaLeavesBlock && event.getEntity().m_21205_().m_41720_() == Items.f_42574_) {
            event.setNewSpeed(15.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        boolean blockOnlyNaturalSpawns;
        Mob entity = event.getEntity();
        LevelAccessor world = event.getLevel();
        RandomSource random = world.m_213780_();
        boolean naturalSpawn = event.getSpawnReason() == MobSpawnType.NATURAL;
        boolean chunkGenSpawn = event.getSpawnReason() == MobSpawnType.CHUNK_GENERATION;
        boolean validSpawn = naturalSpawn || chunkGenSpawn;
        boolean replaceVariants = (Boolean)EnvironmentalConfig.COMMON.biomeVariantsAlwaysSpawn.get();
        if (event.getResult() != Event.Result.DENY && world instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverWorld = (ServerLevelAccessor)world;
            if (replaceVariants && validSpawn && entity.m_20186_() > 60.0) {
                if (entity.m_6095_() == EntityType.f_20501_) {
                    Zombie zombie = (Zombie)entity;
                    if (world.m_204166_(entity.m_20183_()).m_203656_(EnvironmentalBiomeTags.HAS_HUSK)) {
                        Husk husk = (Husk)EntityType.f_20458_.m_20615_((Level)serverWorld.m_6018_());
                        husk.m_6863_(zombie.m_6162_());
                        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                            zombie.m_8061_(equipmentSlot, zombie.m_6844_(equipmentSlot));
                        }
                        husk.m_7678_(zombie.m_20185_(), zombie.m_20186_(), zombie.m_20189_(), zombie.m_146908_(), zombie.m_146909_());
                        world.m_7967_((Entity)husk);
                        entity.m_146870_();
                    }
                }
                if (entity.m_6095_() == EntityType.f_20524_) {
                    Skeleton skeleton = (Skeleton)entity;
                    if (world.m_204166_(entity.m_20183_()).m_203656_(EnvironmentalBiomeTags.HAS_STRAY)) {
                        Stray stray = (Stray)EntityType.f_20481_.m_20615_((Level)serverWorld.m_6018_());
                        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                            skeleton.m_8061_(equipmentSlot, skeleton.m_6844_(equipmentSlot));
                        }
                        stray.m_7678_(skeleton.m_20185_(), skeleton.m_20186_(), skeleton.m_20189_(), skeleton.m_146908_(), skeleton.m_146909_());
                        world.m_7967_((Entity)stray);
                        entity.m_146870_();
                    }
                }
            }
            if (validSpawn && entity.m_6095_() == EntityType.f_20504_) {
                MushroomCow mooshroom = (MushroomCow)event.getEntity();
                if (random.m_188503_(3) == 0) {
                    MushroomCow brownMooshroom = (MushroomCow)EntityType.f_20504_.m_20615_((Level)serverWorld.m_6018_());
                    brownMooshroom.m_7678_(mooshroom.m_20185_(), mooshroom.m_20186_(), mooshroom.m_20189_(), mooshroom.m_146908_(), mooshroom.m_146909_());
                    brownMooshroom.m_28928_(MushroomCow.MushroomType.BROWN);
                    world.m_7967_((Entity)brownMooshroom);
                    entity.m_146870_();
                }
            }
        }
        if ((blockOnlyNaturalSpawns = ((Boolean)EnvironmentalConfig.COMMON.blockOnlyNaturalSpawns.get()).booleanValue()) && event.isSpawner()) {
            return;
        }
        if (!entity.m_6095_().m_204039_(EnvironmentalEntityTypeTags.UNAFFECTED_BY_SERENITY) && entity.m_6095_().m_20674_() == MobCategory.MONSTER) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (Entity koi : world.m_45976_(Koi.class, entity.m_20191_().m_82377_((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (!(MathUtil.distanceBetweenPoints2d((double)entity.m_20185_(), (double)entity.m_20189_(), (double)koi.m_20185_(), (double)koi.m_20189_()) <= (double)horizontalRange)) continue;
                event.setResult(Event.Result.DENY);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        List list;
        Entity itemstack;
        Entity entity = event.getEntity();
        if (entity instanceof ThrownPotion) {
            AABB axisalignedbb;
            List slabs;
            ThrownPotion potionEntity = (ThrownPotion)entity;
            itemstack = potionEntity.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            list = PotionUtils.m_43547_((ItemStack)itemstack);
            if (potion == Potions.f_43599_ && list.isEmpty() && !(slabs = potionEntity.f_19853_.m_45976_(Slabfish.class, axisalignedbb = potionEntity.m_20191_().m_82377_(2.0, 1.0, 2.0))).isEmpty()) {
                for (Slabfish slabfish : slabs) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.NONE);
                }
            }
        }
        if ((itemstack = event.getEntity()) instanceof ThrowableItemProjectile) {
            EntityHitResult entity2;
            ThrowableItemProjectile projectileitem = (ThrowableItemProjectile)itemstack;
            if (event.getRayTraceResult() != null && event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (list = (entity2 = (EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof Slabfish) {
                Slabfish slabfish = (Slabfish)((Object)list);
                ItemStack stack = projectileitem.m_7846_();
                if (stack.m_150930_(Items.f_42452_)) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.SNOWY);
                } else if (stack.m_204117_(Tags.Items.EGGS)) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.EGG);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        Direction face = event.getFace();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item == Items.f_42499_ && state.m_60734_() == Blocks.f_50493_ && world.m_8055_(pos.m_7494_()).m_60631_((BlockGetter)world, pos)) {
            ArrayList<BlockState> potentialStates = new ArrayList<BlockState>();
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                Block block = world.m_8055_(blockpos).m_60734_();
                if (!DIRT_SPREADABLES.contains(block) || potentialStates.contains(block.m_49966_())) continue;
                potentialStates.add(block.m_49966_());
            }
            if (!potentialStates.isEmpty()) {
                if (!world.m_5776_()) {
                    world.m_46796_(2005, pos, 0);
                    world.m_7731_(pos, (BlockState)potentialStates.get(world.m_213780_().m_188503_(potentialStates.size())), 3);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)world.m_5776_()));
                event.setCanceled(true);
            }
        } else if (item instanceof ShovelItem && !player.m_5833_() && state.m_60713_((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get())) {
            Vec3i vector3i = face.m_122436_();
            double d0 = (double)pos.m_123341_() + 0.5 + 0.625 * (double)vector3i.m_123341_();
            double d1 = (double)pos.m_123342_() + 0.375 + 0.625 * (double)vector3i.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5 + 0.625 * (double)vector3i.m_123343_();
            int count = 1;
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
            if (fortuneLevel > 0) {
                count += Math.max(0, world.m_213780_().m_188503_(fortuneLevel + 2) - 1);
            }
            ItemEntity itementity = new ItemEntity(world, d0, d1, d2, new ItemStack((ItemLike)EnvironmentalItems.TRUFFLE.get(), count));
            world.m_7967_((Entity)itementity);
            world.m_5594_(player, pos, (SoundEvent)EnvironmentalSoundEvents.SHOVEL_DIG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)player, damage -> damage.m_21190_(event.getHand()));
            world.m_7731_(pos, Blocks.f_50493_.m_49966_(), 11);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)world.m_5776_()));
            event.setCanceled(true);
        } else if (event.getFace() != Direction.DOWN && item instanceof ShovelItem && !player.m_5833_() && world.m_46859_(pos.m_7494_()) && (state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50195_))) {
            world.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)player, damage -> damage.m_21190_(event.getHand()));
            world.m_7731_(pos, state.m_60713_(Blocks.f_50599_) ? ((Block)EnvironmentalBlocks.PODZOL_PATH.get()).m_49966_() : ((Block)EnvironmentalBlocks.MYCELIUM_PATH.get()).m_49966_(), 11);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)world.m_5776_()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        IDataManager data;
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Level world = event.getLevel();
        RandomSource random = world.m_213780_();
        if (target instanceof Slabfish && stack.m_41720_() == Items.f_42656_) {
            Slabfish slabby = (Slabfish)event.getTarget();
            if (!(!stack.m_41788_() || slabby.m_8077_() && slabby.m_7770_() != null && slabby.m_7770_().getString().equals(stack.m_41786_().getString()))) {
                slabby.playTransformSound();
            }
        }
        if (target instanceof Pig && stack.m_41720_() == Items.f_42677_ && target.m_6084_() && !((Pig)target).m_6162_() && (Integer)(data = (IDataManager)target).getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) == 0) {
            if (world.m_6042_().f_63858_()) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)4800);
                if (!event.getEntity().m_7500_()) {
                    stack.m_41774_(1);
                }
                if (world.m_5776_()) {
                    for (int i = 0; i < 7; ++i) {
                        double d0 = random.m_188583_() * 0.02;
                        double d1 = random.m_188583_() * 0.02;
                        double d2 = random.m_188583_() * 0.02;
                        world.m_7106_((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), target.m_20208_(1.0), target.m_20187_() + 0.5, target.m_20262_(1.0), d0, d1, d2);
                    }
                }
            } else if (world.m_5776_()) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = random.m_188583_() * 0.02;
                    double d1 = random.m_188583_() * 0.02;
                    double d2 = random.m_188583_() * 0.02;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, target.m_20208_(1.0), target.m_20187_() + 0.5, target.m_20262_(1.0), d0, d1, d2);
                }
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)world.m_5776_()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_20193_();
        RandomSource rand = RandomSource.m_216327_();
        if (entity instanceof Slabfish) {
            Slabfish slabfish = (Slabfish)event.getEntity();
            if (world.m_204166_(entity.m_20183_()).m_203565_(Biomes.f_48199_) && !slabfish.getSlabfishType().equals((Object)SlabfishManager.GHOST)) {
                if (world.m_5776_()) {
                    for (int i = 0; i < 7; ++i) {
                        double d0 = rand.m_188583_() * 0.02;
                        double d1 = rand.m_188583_() * 0.02;
                        double d2 = rand.m_188583_() * 0.02;
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123746_, entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                    }
                }
                if (!world.m_5776_()) {
                    Slabfish ghost = (Slabfish)((EntityType)EnvironmentalEntityTypes.SLABFISH.get()).m_20615_(world);
                    if (ghost == null) {
                        return;
                    }
                    ghost.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 140, 0, false, false));
                    ghost.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 140, 0, false, false));
                    world.m_5594_(null, new BlockPos(entity.m_20182_()), SoundEvents.f_11887_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ghost.m_6034_(slabfish.m_20185_(), slabfish.m_20186_(), slabfish.m_20189_());
                    ghost.m_7678_(slabfish.m_20185_(), slabfish.m_20186_(), slabfish.m_20189_(), slabfish.m_146908_(), slabfish.m_146909_());
                    ghost.m_21557_(slabfish.m_21525_());
                    ghost.m_146762_(slabfish.m_146764_());
                    ghost.setSlabfishType(SlabfishManager.GHOST);
                    ghost.m_20254_(0);
                    if (slabfish.m_8077_()) {
                        ghost.m_6593_(entity.m_7770_());
                        ghost.m_20340_(entity.m_20151_());
                    }
                    world.m_7967_((Entity)ghost);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        if (event.getParentA() instanceof Pig && event.getParentB() instanceof Pig) {
            Pig pig = (Pig)event.getParentA();
            Level world = pig.m_20193_();
            int piglets = world.f_46441_.m_188503_(4);
            for (int i = 0; i < piglets; ++i) {
                Pig baby = (Pig)EntityType.f_20510_.m_20615_(world);
                if (baby == null) continue;
                baby.m_6863_(true);
                baby.m_7678_(pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), 0.0f, 0.0f);
                world.m_7967_((Entity)baby);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)wolf, Animal.class, false, targetEntity -> targetEntity.m_6095_() == EnvironmentalEntityTypes.DEER.get()));
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            ocelot.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Animal.class, 10, false, false, targetEntity -> targetEntity.m_6095_() == EnvironmentalEntityTypes.DUCK.get()));
        } else if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            Set goals = pig.f_21345_.f_25345_;
            if (goals.stream().noneMatch(goal -> goal.m_26015_() instanceof HuntTruffleGoal)) {
                pig.f_21345_.m_25352_(2, (Goal)new HuntTruffleGoal(pig));
            }
            if ((pig.m_21573_() instanceof GroundPathNavigation || pig.m_21573_() instanceof FlyingPathNavigation) && goals.stream().noneMatch(goal -> goal.m_26015_() instanceof TemptGoldenCarrotGoal)) {
                pig.f_21345_.m_25352_(4, (Goal)new TemptGoldenCarrotGoal((PathfinderMob)pig, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42677_}), false));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_20193_();
        RandomSource random = world.m_213780_();
        if (entity instanceof Pig && entity.m_6084_()) {
            IDataManager data = (IDataManager)entity;
            int huntingtime = (Integer)data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME);
            BlockPos trufflepos = (BlockPos)data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
            if (huntingtime == 0 || ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && world.m_8055_(trufflepos).m_60734_() != EnvironmentalBlocks.BURIED_TRUFFLE.get()) {
                data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)false);
                if (huntingtime > 0) {
                    data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)Math.max(-400, -huntingtime));
                }
            } else if (huntingtime > 0) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime - 1));
            } else if (huntingtime < 0) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime + 1));
                if (world.m_5776_() && ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && huntingtime % 10 == 0) {
                    double d0 = random.m_188583_() * 0.02;
                    double d1 = random.m_188583_() * 0.02;
                    double d2 = random.m_188583_() * 0.02;
                    world.m_7106_((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), d0, d1, d2);
                }
            }
            int sniffsoundtime = (Integer)data.getValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME);
            data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)(sniffsoundtime + 1));
            if (!world.m_5776_() && ((Boolean)data.getValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE)).booleanValue() && random.m_188503_(60) < sniffsoundtime) {
                entity.m_5496_((SoundEvent)EnvironmentalSoundEvents.PIG_SNIFF.get(), 1.0f, (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
                data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)-20);
            }
        }
    }
}

