/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalBiomeModifierTypes {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"environmental");
    public static final RegistryObject<Codec<InvertedRemoveSpawnsBiomeModifier>> REMOVE_SPAWNS_INVERTED = BIOME_MODIFIER_SERIALIZERS.register("remove_spawns_inverted", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("inverted_biomes").forGetter(InvertedRemoveSpawnsBiomeModifier::biomes), (App)RegistryCodecs.m_206277_((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES).fieldOf("entity_types").forGetter(InvertedRemoveSpawnsBiomeModifier::entityTypes)).apply((Applicative)builder, InvertedRemoveSpawnsBiomeModifier::new)));

    public record InvertedRemoveSpawnsBiomeModifier(HolderSet<Biome> biomes, HolderSet<EntityType<?>> entityTypes) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.REMOVE && !this.biomes.m_203333_(biome)) {
                MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
                for (MobCategory category : MobCategory.values()) {
                    List spawns = spawnBuilder.getSpawner(category);
                    spawns.removeIf(spawnerData -> this.entityTypes.m_203333_((Holder)ForgeRegistries.ENTITY_TYPES.getHolder((Object)spawnerData.f_48404_).get()));
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)REMOVE_SPAWNS_INVERTED.get();
        }
    }
}

