/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.teamabnormals.blueprint.core.util.registry.BiomeSubRegistryHelper;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalGeneration;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalBiomes {
    public static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Environmental.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome MARSH = HELPER.createBiome("marsh", EnvironmentalBiomes::marsh);
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_WOODS = HELPER.createBiome("blossom_woods", EnvironmentalBiomes::blossomWoods);
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_VALLEYS = HELPER.createBiome("blossom_valleys", EnvironmentalBiomes::blossomValleys);

    private static Biome marsh() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        EnvironmentalGeneration.withMarshFeatures(generation);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        Music music = Musics.m_11653_((SoundEvent)SoundEvents.f_215730_);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6134398).m_48037_(2302743).m_48019_(12638463).m_48040_(EnvironmentalBiomes.getSkyColorWithTemperatureModifier(0.75f)).m_48045_(6263617).m_48043_(6975545).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome blossomWoods() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        EnvironmentalGeneration.withBlossomWoodsFeatures(generation);
        return EnvironmentalBiomes.blossomBiome(generation);
    }

    private static Biome blossomValleys() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        EnvironmentalGeneration.withBlossomValleysFeatures(generation);
        return EnvironmentalBiomes.blossomBiome(generation);
    }

    private static Biome blossomBiome(BiomeGenerationSettings.Builder generation) {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20507_, 16, 1, 2));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.KOI.get(), 12, 1, 1));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.75f).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(5216182).m_48037_(335411).m_48019_(12638463).m_48040_(EnvironmentalBiomes.getSkyColorWithTemperatureModifier(0.75f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = Mth.m_14036_((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

