/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.block.CartwheelBlock;
import com.teamabnormals.environmental.common.levelgen.feature.BigWisteriaTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.CattailsFeature;
import com.teamabnormals.environmental.common.levelgen.feature.CherryTreeFeature;
import com.teamabnormals.environmental.common.levelgen.feature.DenseCattailsFeature;
import com.teamabnormals.environmental.common.levelgen.feature.FallenLeavesFeature;
import com.teamabnormals.environmental.common.levelgen.feature.WisteriaTreeFeature;
import com.teamabnormals.environmental.common.levelgen.treedecorators.HangingWillowLeavesTreeDecorator;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"environmental");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATORS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"environmental");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FALLEN_LEAVES = FEATURES.register("fallen_leaves", () -> new FallenLeavesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CATTAILS = FEATURES.register("cattails", () -> new CattailsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> DENSE_CATTAILS = FEATURES.register("dense_cattails", () -> new DenseCattailsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<TreeConfiguration>> CHERRY_TREE = FEATURES.register("cherry_tree", () -> new CherryTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> WISTERIA_TREE = FEATURES.register("wisteria_tree", () -> new WisteriaTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> BIG_WISTERIA_TREE = FEATURES.register("big_wisteria_tree", () -> new BigWisteriaTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<TreeDecoratorType<?>> HANGING_WILLOW_LEAVES = TREE_DECORATORS.register("hanging_willow_leaves", () -> new TreeDecoratorType(HangingWillowLeavesTreeDecorator.CODEC));

    public static final class EnvironmentalPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"environmental");
        public static final RegistryObject<PlacedFeature> DISK_MUD = EnvironmentalPlacedFeatures.register("disk_mud", EnvironmentalConfiguredFeatures.DISK_MUD, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> SEAGRASS_MARSH = EnvironmentalPlacedFeatures.register("seagrass_marsh", EnvironmentalConfiguredFeatures.SEAGRASS_MID, AquaticPlacements.m_195233_((int)128));
        public static final RegistryObject<PlacedFeature> PATCH_WATERLILY_MARSH = EnvironmentalPlacedFeatures.register("patch_waterlily", EnvironmentalConfiguredFeatures.PATCH_WATERLILY, VegetationPlacements.m_195474_((int)1));
        public static final RegistryObject<PlacedFeature> PATCH_DUCKWEED = EnvironmentalPlacedFeatures.register("patch_duckweed", EnvironmentalConfiguredFeatures.PATCH_DUCKWEED, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.125f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_DUCKWEED_SWAMP = EnvironmentalPlacedFeatures.register("patch_duckweed_swamp", EnvironmentalConfiguredFeatures.PATCH_DUCKWEED, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.125f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_BLUE_ORCHID = EnvironmentalPlacedFeatures.register("flower_blue_orchid", EnvironmentalConfiguredFeatures.FLOWER_BLUE_ORCHID, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_CORNFLOWER = EnvironmentalPlacedFeatures.register("flower_cornflower", EnvironmentalConfiguredFeatures.FLOWER_CORNFLOWER, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_DIANTHUS = EnvironmentalPlacedFeatures.register("flower_dianthus", EnvironmentalConfiguredFeatures.FLOWER_DIANTHUS, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_CARTWHEEL = EnvironmentalPlacedFeatures.register("flower_cartwheel", EnvironmentalConfiguredFeatures.FLOWER_CARTWHEEL, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_BLUEBELL = EnvironmentalPlacedFeatures.register("flower_bluebell", EnvironmentalConfiguredFeatures.FLOWER_BLUEBELL, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_VIOLET = EnvironmentalPlacedFeatures.register("flower_violet", EnvironmentalConfiguredFeatures.FLOWER_VIOLET, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_ALLIUM = EnvironmentalPlacedFeatures.register("flower_allium", EnvironmentalConfiguredFeatures.FLOWER_ALLIUM, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_RED_LOTUS = EnvironmentalPlacedFeatures.register("flower_red_lotus", EnvironmentalConfiguredFeatures.FLOWER_RED_LOTUS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_WHITE_LOTUS = EnvironmentalPlacedFeatures.register("flower_white_lotus", EnvironmentalConfiguredFeatures.FLOWER_WHITE_LOTUS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_HIBISCUS_WARM = EnvironmentalPlacedFeatures.register("flower_hibiscus_warm", EnvironmentalConfiguredFeatures.FLOWER_HIBISCUS_WARM, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_HIBISCUS_COOL = EnvironmentalPlacedFeatures.register("flower_hibiscus_cool", EnvironmentalConfiguredFeatures.FLOWER_HIBISCUS_COOL, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FLOWER_BIRD_OF_PARADISE = EnvironmentalPlacedFeatures.register("flower_bird_of_paradise", EnvironmentalConfiguredFeatures.FLOWER_BIRD_OF_PARADISE, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_TULIPS = EnvironmentalPlacedFeatures.register("patch_tulips", EnvironmentalConfiguredFeatures.PATCH_TULIPS, new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FOREST_FLOWERS = EnvironmentalPlacedFeatures.register("forest_flowers", EnvironmentalConfiguredFeatures.FOREST_FLOWERS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, CountPlacement.m_191630_((IntProvider)ClampedInt.m_146395_((IntProvider)UniformInt.m_146622_((int)-3, (int)1), (int)0, (int)1)), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> WHITE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("white_wisteria_bees_002", EnvironmentalConfiguredFeatures.WHITE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> PINK_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("pink_wisteria_bees_002", EnvironmentalConfiguredFeatures.PINK_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> PURPLE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("purple_wisteria_bees_002", EnvironmentalConfiguredFeatures.PURPLE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> BLUE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.register("blue_wisteria_bees_002", EnvironmentalConfiguredFeatures.BLUE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> TREES_WISTERIA = EnvironmentalPlacedFeatures.register("trees_wisteria", EnvironmentalConfiguredFeatures.TREES_WISTERIA, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.01f, (int)1)));
        public static final RegistryObject<PlacedFeature> PATCH_DELPHINIUMS = EnvironmentalPlacedFeatures.register("patch_delphiniums", EnvironmentalConfiguredFeatures.PATCH_DELPHINIUMS, new PlacementModifier[]{RarityFilter.m_191900_((int)12), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> TREES_MARSH = EnvironmentalPlacedFeatures.register("trees_marsh", EnvironmentalConfiguredFeatures.SWAMP_OAK, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1)));
        public static final RegistryObject<PlacedFeature> TREES_SWAMP = EnvironmentalPlacedFeatures.register("trees_swamp", EnvironmentalConfiguredFeatures.SWAMP_OAK, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.05f, (int)1)));
        public static final RegistryObject<PlacedFeature> HUGE_BROWN_MUSHROOM_MARSH = EnvironmentalPlacedFeatures.register("huge_brown_mushroom_marsh", EnvironmentalConfiguredFeatures.HUGE_BROWN_MUSHROOM, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.025f, (int)1)));
        public static final RegistryObject<PlacedFeature> HUGE_SWAMP_MUSHROOMS = EnvironmentalPlacedFeatures.register("huge_swamp_mushrooms", EnvironmentalConfiguredFeatures.HUGE_SWAMP_MUSHROOMS, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CHERRY_TREES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("cherry_tree_blossom_woods", EnvironmentalConfiguredFeatures.CHERRY_BEES_0002, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)8, (float)0.05f, (int)1), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> CHERRY_TREES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("cherry_tree_blossom_valleys", EnvironmentalConfiguredFeatures.CHERRY_BEES_005, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.2f, (int)1), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> BIRCH_TREES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("birch_tree_blossom_woods", EnvironmentalConfiguredFeatures.TREES_BIRCH, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)5, (float)0.1f, (int)2), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> BIRCH_TREES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("birch_tree_blossom_valleys", EnvironmentalConfiguredFeatures.TREES_BIRCH, VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), (Block)Blocks.f_50748_));
        public static final RegistryObject<PlacedFeature> FALLEN_CHERRY_LEAVES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("fallen_cherry_leaves_blossom_woods", EnvironmentalConfiguredFeatures.FALLEN_CHERRY_LEAVES, new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> FALLEN_CHERRY_LEAVES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("fallen_cherry_leaves_blossom_valleys", EnvironmentalConfiguredFeatures.FALLEN_CHERRY_LEAVES, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("bamboo_blossom_woods", EnvironmentalConfiguredFeatures.BAMBOO_NO_PODZOL, new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)11, (double)5.0, (double)0.2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_LIGHT_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("bamboo_light_blossom_woods", EnvironmentalConfiguredFeatures.BAMBOO_NO_PODZOL, new PlacementModifier[]{RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("bamboo_blossom_valleys", EnvironmentalConfiguredFeatures.BAMBOO_NO_PODZOL, new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)5, (double)5.0, (double)0.2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BAMBOO_LIGHT_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.register("bamboo_light_blossom_valleys", EnvironmentalConfiguredFeatures.BAMBOO_NO_PODZOL, new PlacementModifier[]{RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_MARSH = EnvironmentalPlacedFeatures.register("patch_grass_marsh", EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.m_195474_((int)5));
        public static final RegistryObject<PlacedFeature> PATCH_GRASS_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.register("patch_grass_blossom_woods", EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.m_195474_((int)12));
        public static final RegistryObject<PlacedFeature> PATCH_MYCELIUM_SPROUTS = EnvironmentalPlacedFeatures.register("patch_mycelium_sprouts", EnvironmentalConfiguredFeatures.PATCH_MYCELIUM_SPROUTS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_PLAINS = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_plains", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_SAVANNA = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_savanna", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_JUNGLE = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_jungle", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_GIANT_TALL_GRASS_MARSH = EnvironmentalPlacedFeatures.register("patch_giant_tall_grass_marsh", EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{CountPlacement.m_191628_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CATTAILS = EnvironmentalPlacedFeatures.register("cattails", EnvironmentalConfiguredFeatures.CATTAILS, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CATTAILS_DENSE = EnvironmentalPlacedFeatures.register("cattails_dense", EnvironmentalConfiguredFeatures.CATTAILS_DENSE, new PlacementModifier[]{RarityFilter.m_191900_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_SUGAR_CANE_BLOSSOM = EnvironmentalPlacedFeatures.register("patch_sugar_cane_blossom", EnvironmentalConfiguredFeatures.PATCH_SUGAR_CANE, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_TALL_DEAD_BUSH = EnvironmentalPlacedFeatures.register("patch_tall_dead_bush", EnvironmentalConfiguredFeatures.PATCH_TALL_DEAD_BUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)16), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_TALL_DEAD_BUSH_BADLANDS = EnvironmentalPlacedFeatures.register("patch_tall_dead_bush_badlands", EnvironmentalConfiguredFeatures.PATCH_TALL_DEAD_BUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
            return EnvironmentalPlacedFeatures.register(name, feature, List.of(placementModifiers));
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Collection)placementModifiers)));
        }
    }

    public static final class EnvironmentalConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"environmental");
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WILLOW = EnvironmentalConfiguredFeatures.register("willow", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.createStraightBlobTree((Block)EnvironmentalBlocks.WILLOW_LOG.get(), (Block)EnvironmentalBlocks.WILLOW_LEAVES.get(), 5, 3, 0, 3).m_68249_((List)ImmutableList.of((Object)new LeaveVineDecorator(0.25f), (Object)((Object)HangingWillowLeavesTreeDecorator.INSTANCE))).m_68251_()));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> TREES_BIRCH = EnvironmentalConfiguredFeatures.register("trees_birch", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.createStraightBlobTree(Blocks.f_50001_, Blocks.f_50052_, 5, 2, 6, 2).m_68244_().m_68249_((List)ImmutableList.of((Object)Configs.BEEHIVE_0002)).m_68251_()));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> SWAMP_OAK = EnvironmentalConfiguredFeatures.register("swamp_oak", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.f_195385_, 0.33333334f)), TreePlacements.f_195374_)));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHERRY = EnvironmentalConfiguredFeatures.register("cherry", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHERRY));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHERRY_BEES_0002 = EnvironmentalConfiguredFeatures.register("cherry_bees_0002", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHERRY_BEES_0002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> CHERRY_BEES_005 = EnvironmentalConfiguredFeatures.register("cherry_bees_005", () -> new ConfiguredFeature((Feature)CHERRY_TREE.get(), (FeatureConfiguration)Configs.CHERRY_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WHITE_WISTERIA = EnvironmentalConfiguredFeatures.register("white_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.WHITE_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WHITE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("white_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.WHITE_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WHITE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("white_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.WHITE_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> BLUE_WISTERIA = EnvironmentalConfiguredFeatures.register("blue_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.BLUE_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> BLUE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("blue_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.BLUE_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> BLUE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("blue_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.BLUE_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PURPLE_WISTERIA = EnvironmentalConfiguredFeatures.register("purple_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PURPLE_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PURPLE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("purple_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PURPLE_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PURPLE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("purple_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PURPLE_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINK_WISTERIA = EnvironmentalConfiguredFeatures.register("pink_wisteria", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PINK_WISTERIA));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINK_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.register("pink_wisteria_bees_002", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PINK_WISTERIA_BEES_002));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINK_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.register("pink_wisteria_bees_005", () -> new ConfiguredFeature((Feature)WISTERIA_TREE.get(), (FeatureConfiguration)Configs.PINK_WISTERIA_BEES_005));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_WISTERIA = EnvironmentalConfiguredFeatures.register("trees_wisteria", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.PINK_WISTERIA_BEES_002.getHolder().get(), 0.25f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.BLUE_WISTERIA_BEES_002.getHolder().get(), 0.25f), new WeightedPlacedFeature((Holder)EnvironmentalPlacedFeatures.PURPLE_WISTERIA_BEES_002.getHolder().get(), 0.25f)), (Holder)EnvironmentalPlacedFeatures.WHITE_WISTERIA_BEES_002.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_BLUE_ORCHID = EnvironmentalConfiguredFeatures.register("flower_blue_orchid", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50113_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_CORNFLOWER = EnvironmentalConfiguredFeatures.register("flower_cornflower", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50121_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_DIANTHUS = EnvironmentalConfiguredFeatures.register("flower_dianthus", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.DIANTHUS.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_BLUEBELL = EnvironmentalConfiguredFeatures.register("flower_bluebell", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(128, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.BLUEBELL.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_VIOLET = EnvironmentalConfiguredFeatures.register("flower_violet", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(32, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.VIOLET.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_ALLIUM = EnvironmentalConfiguredFeatures.register("flower_allium", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50114_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_RED_LOTUS = EnvironmentalConfiguredFeatures.register("flower_red_lotus", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(24, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.RED_LOTUS_FLOWER.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_WHITE_LOTUS = EnvironmentalConfiguredFeatures.register("flower_white_lotus", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(24, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_HIBISCUS_WARM = EnvironmentalConfiguredFeatures.register("flower_hibiscus_warm", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(128, 7, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)EnvironmentalBlocks.RED_HIBISCUS.get()).m_49966_(), 1).m_146271_((Object)((Block)EnvironmentalBlocks.ORANGE_HIBISCUS.get()).m_49966_(), 2).m_146271_((Object)((Block)EnvironmentalBlocks.YELLOW_HIBISCUS.get()).m_49966_(), 3)))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_HIBISCUS_COOL = EnvironmentalConfiguredFeatures.register("flower_hibiscus_cool", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(128, 7, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)EnvironmentalBlocks.PURPLE_HIBISCUS.get()).m_49966_(), 1).m_146271_((Object)((Block)EnvironmentalBlocks.MAGENTA_HIBISCUS.get()).m_49966_(), 2).m_146271_((Object)((Block)EnvironmentalBlocks.PINK_HIBISCUS.get()).m_49966_(), 3)))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_CARTWHEEL = EnvironmentalConfiguredFeatures.register("flower_cartwheel", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.NORTH)), 1).m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.SOUTH)), 1).m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.EAST)), 1).m_146271_((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).m_49966_().m_61124_((Property)CartwheelBlock.FACING, (Comparable)Direction.WEST)), 1)))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_BIRD_OF_PARADISE = EnvironmentalConfiguredFeatures.register("flower_bird_of_paradise", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.BIRD_OF_PARADISE.get()))), List.of(), (int)32)));
        public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> PATCH_DELPHINIUMS = EnvironmentalConfiguredFeatures.register("patch_delphiniums", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0])}))));
        public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> PATCH_TULIPS = EnvironmentalConfiguredFeatures.register("patch_tulips", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50118_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50116_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50119_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50117_))), (PlacementModifier[])new PlacementModifier[0])}))));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> CATTAILS = EnvironmentalConfiguredFeatures.register("cattails", () -> new ConfiguredFeature((Feature)CATTAILS.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> CATTAILS_DENSE = EnvironmentalConfiguredFeatures.register("cattails_dense", () -> new ConfiguredFeature((Feature)DENSE_CATTAILS.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_DUCKWEED = EnvironmentalConfiguredFeatures.register("patch_duckweed", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(1024, 8, 5, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.DUCKWEED.get())))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_GIANT_TALL_GRASS = EnvironmentalConfiguredFeatures.register("patch_giant_tall_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get())), 64)));
        public static final RegistryObject<ConfiguredFeature<HugeMushroomFeatureConfiguration, ?>> HUGE_BROWN_MUSHROOM = EnvironmentalConfiguredFeatures.register("huge_brown_mushroom", () -> new ConfiguredFeature(Feature.f_65772_, (FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((BlockState)Blocks.f_50180_.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((BlockState)Blocks.f_50182_.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)))), 3)));
        public static final RegistryObject<ConfiguredFeature<DiskConfiguration, ?>> DISK_MUD = EnvironmentalConfiguredFeatures.register("disk_mud", () -> new ConfiguredFeature(Feature.f_65781_, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)Blocks.f_220864_), BlockPredicate.m_198311_(List.of(Blocks.f_50493_, Blocks.f_220864_)), (IntProvider)UniformInt.m_146622_((int)1, (int)4), 1)));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> BAMBOO_NO_PODZOL = EnvironmentalConfiguredFeatures.register("bamboo_no_podzol", () -> new ConfiguredFeature(Feature.f_65742_, (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.0f)));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> FALLEN_CHERRY_LEAVES = EnvironmentalConfiguredFeatures.register("fallen_cherry_leaves", () -> new ConfiguredFeature((Feature)FALLEN_LEAVES.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_TALL_DEAD_BUSH = EnvironmentalConfiguredFeatures.register("patch_tall_dead_bush", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)EnvironmentalBlocks.TALL_DEAD_BUSH.get()).m_49966_(), 2).m_146271_((Object)Blocks.f_50036_.m_49966_(), 1))), List.of(), (int)64)));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_MYCELIUM_SPROUTS = EnvironmentalConfiguredFeatures.register("patch_mycelium_sprouts", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get())), 32)));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_WATERLILY = EnvironmentalConfiguredFeatures.register("patch_waterlily", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(10, 7, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50196_))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_SUGAR_CANE = EnvironmentalConfiguredFeatures.register("patch_sugar_cane", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(20, 4, 0, PlacementUtils.m_206502_((Feature)Feature.f_190875_, (FeatureConfiguration)BlockColumnConfiguration.m_191224_((IntProvider)BiasedToBottomInt.m_146367_((int)2, (int)4), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50130_)), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.f_190393_, BlockPredicate.m_190399_((BlockState)Blocks.f_50130_.m_49966_(), (Vec3i)BlockPos.f_121853_), BlockPredicate.m_190430_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_224777_((Vec3i)new BlockPos(1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(-1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, 1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, -1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_})})}))}))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_GRASS = EnvironmentalConfiguredFeatures.register("patch_grass", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50034_), 32)));
        public static final RegistryObject<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> FOREST_FLOWERS = EnvironmentalConfiguredFeatures.register("forest_flowers", () -> new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50356_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50357_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50358_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65762_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50071_))), (PlacementModifier[])new PlacementModifier[0])}))));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> SEAGRASS_MID = EnvironmentalConfiguredFeatures.register("seagrass_mid", () -> new ConfiguredFeature((Feature)Feature.f_65735_, (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.6f)));
        public static final RegistryObject<ConfiguredFeature<RandomBooleanFeatureConfiguration, ?>> HUGE_SWAMP_MUSHROOMS = EnvironmentalConfiguredFeatures.register("huge_swamp_mushrooms", () -> new ConfiguredFeature(Feature.f_65756_, (FeatureConfiguration)new RandomBooleanFeatureConfiguration(PlacementUtils.m_206506_((Holder)TreeFeatures.f_195122_, (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206506_((Holder)TreeFeatures.f_195121_, (PlacementModifier[])new PlacementModifier[0]))));

        private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int p_195204_) {
            return FeatureUtils.m_206470_((int)p_195204_, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block p_195147_, Block p_195148_, int p_195149_, int p_195150_, int p_195151_, int p_195152_) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)p_195147_), (TrunkPlacer)new StraightTrunkPlacer(p_195149_, p_195150_, p_195151_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)p_195148_), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)p_195152_), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
        }

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }

    public static final class Configs {
        private static final BeehiveDecorator BEEHIVE_0002 = new BeehiveDecorator(0.002f);
        private static final BeehiveDecorator BEEHIVE_002 = new BeehiveDecorator(0.02f);
        private static final BeehiveDecorator BEEHIVE_005 = new BeehiveDecorator(0.05f);
        public static final TreeConfiguration CHERRY = Configs.createCherry().m_68251_();
        public static final TreeConfiguration CHERRY_BEES_0002 = Configs.createCherry().m_68249_(List.of(BEEHIVE_0002)).m_68251_();
        public static final TreeConfiguration CHERRY_BEES_005 = Configs.createCherry().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration WHITE_WISTERIA = Configs.createWhiteWisteria().m_68251_();
        public static final TreeConfiguration WHITE_WISTERIA_BEES_002 = Configs.createWhiteWisteria().m_68249_(List.of(BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration WHITE_WISTERIA_BEES_005 = Configs.createWhiteWisteria().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration BLUE_WISTERIA = Configs.createBlueWisteria().m_68251_();
        public static final TreeConfiguration BLUE_WISTERIA_BEES_002 = Configs.createBlueWisteria().m_68249_(List.of(BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration BLUE_WISTERIA_BEES_005 = Configs.createBlueWisteria().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration PURPLE_WISTERIA = Configs.createPurpleWisteria().m_68251_();
        public static final TreeConfiguration PURPLE_WISTERIA_BEES_002 = Configs.createPurpleWisteria().m_68249_(List.of(BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration PURPLE_WISTERIA_BEES_005 = Configs.createPurpleWisteria().m_68249_(List.of(BEEHIVE_005)).m_68251_();
        public static final TreeConfiguration PINK_WISTERIA = Configs.createPinkWisteria().m_68251_();
        public static final TreeConfiguration PINK_WISTERIA_BEES_002 = Configs.createPinkWisteria().m_68249_(List.of(BEEHIVE_002)).m_68251_();
        public static final TreeConfiguration PINK_WISTERIA_BEES_005 = Configs.createPinkWisteria().m_68249_(List.of(BEEHIVE_005)).m_68251_();

        private static TreeConfiguration.TreeConfigurationBuilder createCherry() {
            return Configs.createCustomTree(((Block)EnvironmentalBlocks.CHERRY_LOG.get()).m_49966_(), ((Block)EnvironmentalBlocks.CHERRY_LEAVES.get()).m_49966_());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createWhiteWisteria() {
            return Configs.createCustomTree(((Block)EnvironmentalBlocks.WISTERIA_LOG.get()).m_49966_(), ((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get()).m_49966_());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createBlueWisteria() {
            return Configs.createCustomTree(((Block)EnvironmentalBlocks.WISTERIA_LOG.get()).m_49966_(), ((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get()).m_49966_());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPurpleWisteria() {
            return Configs.createCustomTree(((Block)EnvironmentalBlocks.WISTERIA_LOG.get()).m_49966_(), ((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get()).m_49966_());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPinkWisteria() {
            return Configs.createCustomTree(((Block)EnvironmentalBlocks.WISTERIA_LOG.get()).m_49966_(), ((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get()).m_49966_());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(BlockState logState, BlockState leavesState) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)logState), (TrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)leavesState), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68244_();
        }
    }
}

