/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.teamabnormals.environmental.core.registry.EnvironmentalBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalVillagers {
    public static void registerVillagerTypes() {
        VillagerTrades.f_35627_.isEmpty();
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("ice_spikes"), Biomes.f_48182_);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("flower_forest"), Biomes.f_48179_);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("blossom"), EnvironmentalBiomes.BLOSSOM_WOODS.getKey(), EnvironmentalBiomes.BLOSSOM_VALLEYS.getKey());
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("forest"), Biomes.f_48205_, Biomes.f_48149_, Biomes.f_186762_);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("marsh"), EnvironmentalBiomes.MARSH.getKey());
    }

    private static VillagerType createType(String type) {
        return VillagerType.m_35831_((String)("environmental:" + type));
    }

    @SafeVarargs
    private static void registerVillagerType(VillagerType type, ResourceKey<Biome> ... biomes) {
        for (ResourceKey<Biome> biome : biomes) {
            VillagerType.f_35827_.put(biome, type);
        }
    }
}

