/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModContext;
import snownee.kiwi.NamedEntry;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.loader.event.ServerInitEvent;
import snownee.kiwi.mixin.ItemAccess;

public class ModuleInfo {
    public final AbstractModule module;
    public final ModContext context;
    public CreativeModeTab category;
    final RegistryHolder registries = new RegistryHolder();
    final Map<Block, Item.Properties> blockItemBuilders = Maps.newHashMap();
    final Set<Object> noCategories = Sets.newHashSet();
    final Set<Block> noItems = Sets.newHashSet();

    public ModuleInfo(ResourceLocation rl, AbstractModule module, ModContext context) {
        this.module = module;
        this.context = context;
        module.uid = rl;
        if (DatagenModLoader.isRunningDataGen() && context.modContainer instanceof FMLModContainer) {
            ((FMLModContainer)context.modContainer).getEventBus().addListener(module::gatherData);
        }
    }

    public void register(Object entry, ResourceLocation name, Object registry, @Nullable Field field) {
        this.registries.put(new NamedEntry<Object>(name, entry, registry, field));
    }

    public void handleRegister(Object registry) {
        this.context.setActiveContainer();
        Collection<NamedEntry<?>> entries = this.registries.get(registry);
        BiConsumer<ModuleInfo, Object> decorator = this.module.decorators.getOrDefault(registry, (a, b) -> {});
        if (registry == ForgeRegistries.ITEMS) {
            this.registries.get(ForgeRegistries.BLOCKS).forEach(e -> {
                KiwiModule.Category group;
                if (this.noItems.contains(e.entry)) {
                    return;
                }
                Item.Properties builder = this.blockItemBuilders.get(e.entry);
                if (builder == null) {
                    builder = new Item.Properties();
                }
                Object item = e.entry instanceof IKiwiBlock ? ((IKiwiBlock)e.entry).createItem(builder) : new ModBlockItem((Block)e.entry, builder);
                if (this.noCategories.contains(e.entry)) {
                    this.noCategories.add(item);
                } else if (e.field != null && (group = e.field.getAnnotation(KiwiModule.Category.class)) != null && !group.value().isEmpty()) {
                    CreativeModeTab category = Kiwi.getGroup(group.value());
                    if (category != null) {
                        ((ItemAccess)item).setCategory(category);
                    } else {
                        ((ItemAccess)item).setCategory(this.category);
                    }
                }
                entries.add(new NamedEntry<BlockItem>(e.name, (BlockItem)item, registry, null));
            });
            entries.forEach(e -> {
                KiwiModule.Category group;
                if (e.field != null && (group = e.field.getAnnotation(KiwiModule.Category.class)) != null && !group.value().isEmpty()) {
                    CreativeModeTab category = Kiwi.getGroup(group.value());
                    if (category != null) {
                        ((ItemAccess)e.entry).setCategory(category);
                    } else {
                        ((ItemAccess)e.entry).setCategory(this.category);
                    }
                }
            });
        }
        entries.forEach(e -> {
            decorator.accept(this, e.entry);
            if (registry instanceof Registry) {
                Registry.m_122965_((Registry)((Registry)registry), (ResourceLocation)e.name, e.entry);
            } else if (registry instanceof IForgeRegistry) {
                ((IForgeRegistry)registry).register(e.name, e.entry);
            } else {
                throw new RuntimeException("registry is invalid");
            }
        });
        if (registry == ForgeRegistries.BLOCKS && Platform.isPhysicalClient() && !Platform.isDataGen()) {
            RenderType solid = RenderType.m_110451_();
            HashMap cache = Maps.newHashMap();
            entries.stream().forEach(e -> {
                RenderType type;
                KiwiModule.RenderLayer layer;
                Block block = (Block)e.entry;
                if (e.field != null && (layer = e.field.getAnnotation(KiwiModule.RenderLayer.class)) != null && (type = (RenderType)layer.value().value) != solid && type != null) {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
                    return;
                }
                Class<?> klass = block.getClass();
                type = cache.computeIfAbsent(klass, k -> {
                    KiwiModule.RenderLayer layer = null;
                    while (k != Block.class) {
                        layer = k.getDeclaredAnnotation(KiwiModule.RenderLayer.class);
                        if (layer != null) {
                            return (RenderType)layer.value().value;
                        }
                        k = k.getSuperclass();
                    }
                    return solid;
                });
                if (type != solid && type != null) {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
                }
            });
        }
    }

    public void preInit() {
        KiwiModules.ALL_USED_REGISTRIES.addAll(this.registries.registries.keySet());
        this.context.setActiveContainer();
        this.module.preInit();
    }

    public void init(InitEvent event) {
        this.context.setActiveContainer();
        this.module.init(event);
    }

    public void clientInit(ClientInitEvent event) {
        this.context.setActiveContainer();
        this.module.clientInit(event);
    }

    public void serverInit(ServerInitEvent event) {
        this.context.setActiveContainer();
        this.module.serverInit(event);
    }

    public void postInit(PostInitEvent event) {
        this.context.setActiveContainer();
        this.module.postInit(event);
    }

    public <T> List<T> getRegistries(Object registry) {
        return this.registries.get(registry).stream().map($ -> $.entry).collect(Collectors.toList());
    }

    public static final class RegistryHolder {
        final Multimap<Object, NamedEntry<?>> registries = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().linkedListValues().build();

        void put(NamedEntry<?> entry) {
            this.registries.put(entry.registry, entry);
        }

        Collection<NamedEntry<?>> get(Object registry) {
            return this.registries.get(registry);
        }
    }
}

